<?php

/*
Plugin Name: 1-Click Video Site Builder PRO
Plugin URI: http://1clickvideositebuilder.com
Description: Creates monetized, viral video sites with one click
Author: George Katsoudas
Developer: A. Oliinyk (Pumka.net)
Version: 1.5.2
Author URI: http://www.georgekatsoudas.com
Tested up to: 5.7
*/

/*
Version history:
1.5.2
    fixed VV8-QN9-X1TS Smart Recent Posts widget compatibility
1.5.1
    fixed admin form validation bug
1.5
    added: channel ID check
1.4.2
    added: has_post_thumbnail filter
    minor UI mods
1.4
    added: Option to suppress featured images on generated posts
1.3.14
    fixed: session ID issue
1.3.12
    new API key instruction
1.3.11
    fixed 7H8-7V1-WBPV: cUrl do not accept TRUE for CURLOPT_RETURNTRANSFER on some servers
1.3.10
    disable player styles if vidizon-pro theme is active
1.3.9
    licensing system improvements
1.3.8
    fixed #20825: added workaround for JetPack contact-form module bug
1.3.7
    added: preview notice
1.3.6
    added: workaround for #15201 - check table presence
1.3.5
    added: workaround for themes passing empty
        value to content filters
1.3.4
    workaround for themes applying wptop filter to
        dynamic content
1.3.3
    fixed 7815: apply 7748 fix for channel search only
1.3.2
    ignore duplicate field update error
1.3.1
    workaround for #7748: allow relevance sorting
        and preprocess keywords
1.3
    added: Output YouTube URL into post content
    added: Non-fatal error on invalid channel
    added: Ability to enter a list of YouTube video
        URLs or video IDs
1.2
    added: Newstube theme compatibility
    added: keywords and negative keywords filter for
        channel subscription function.
    added: custom post type support
1.1.5
    fixed: activation screen
1.1.4
    fixed 7630: posts were shared before publication
1.1.3
    activation email info
1.1.2
    fixed: video player not shown
1.1.1
    fixed 7451: fatal error is license not found
1.1
    added: YouTube avatar support
1.0.14
    minor fixes
1.0.13
    fixed 7459: allow fullscreen mode
1.0.12
    fixed 9999: invalid comment dates
1.0.11
    clearer OnlyWire error message
1.0.9
    fixed: corrupted HTML if there is a space in href value
1.0.8
    improved lockfile management
1.0.7
    fixed 7121: multi-word negative keywords need quotes
1.0.6
    updated preview tooltip
1.0.5
    fixed: too many update checks
1.0.4
    comment adding error is not fatal anymore
    fixed 7277: error adding featured image with safe mode on.
    added: featured images option (unchecked by default)
    comment adding error is not fatal anymore
1.0.3
    always add featured images
1.0.2
    fixed: quality level required issue
1.0.1
    fixed: template links were not cloaked
1.0: Initial release
*/

require_once dirname(__FILE__) . '/library/Framework/Core.php';

/**
 * Class ytg_Core
 * @inheritDoc
 * @property ytg_Component_Client_Cpanel $client_Cpanel
 * @property ytg_Component_Client_Onlywire $client_Onlywire
 * @property ytg_Component_Client_Spinrewriter $client_Spinrewriter
 * @property ytg_Component_Client_Youtube $client_Youtube
 *
 * @property ytg_Component_Activate $activate
 * @property ytg_Component_Admin $admin
 * @property ytg_Component_Ajax $ajax
 * @property ytg_Component_Assets $assets
 * @property ytg_Component_BadWordsFilter $badWordsFilter
 * @property ytg_Component_Cron $cron
 * @property ytg_Component_ErrorHandler $errorHandler
 * @property ytg_Component_Frontend $frontend
 * @property ytg_Component_Generator $generator
 * @property ytg_Component_Helper $helper
 * @property ytg_Component_PostTemplate $postTemplate
 * @property ytg_Component_Process $process
 * @property ytg_Component_Setup $setup
 * @property ytg_Component_Update $update
 */
if (!class_exists('ytg_Core')) {
    class ytg_Core extends ytg_Framework_Core
    {
        public $path = __FILE__;
        public $slug = 'one-click-video-site-builder';
        public $prefix = 'ytg';
        public $version = '1.5.2';

        public $demo = FALSE;
    }
} else {
    deactivate_plugins(plugin_basename(__FILE__));
    trigger_error('This plugin cannot be installed together with '
        . ytg_Core::config('plugin/title'), E_USER_ERROR);
    return;
}

ytg_Core::init();
