<?php
ytg_Core::load('Framework_Object');

class ytg_Framework_Widget_Grid extends ytg_Framework_Object
{
    public $id;

    public $modelClass;

    public $condition;
    public $filter;

    public $pageSize = 10;
    public $page = 1;

    public $totalCount;
    public $count; // Reserved for filters
    public $pageCount;

    public $columns = array();

    public $sort;

    public $defaultSort;

    public $urlParams = array();

    public $templateDirectory;

    public $tableClass;

    public $pageParameter = 'p';
    public $sortParameter = 'sort';

    public $emptyMessage = 'No records found.';
    public $emptyMessageFormat = 'text';

    public $queryConfig = array();

    public function init()
    {
        parent::init();

        if (is_null($this->id)) {
            $this->id = $this->modelClass;
        }

        $model = $this->getModel();

        // Process columns
        $columns = array();
        foreach ($this->columns as $name => $column) {
            if (is_int($name)) {
                unset($this->columns[$name]);
                $name = $column;
                $column = array();
            }

            $column['sortable'] = (isset($column['sort']) && FALSE !== $column['sort']
                || $this->getModel()->hasAttribute($name)
                || $this->getModel()->hasProperty($name));
            if (!isset($column['label'])) {
                $column['label'] = $model->hasAttribute($name) || $model->hasProperty($name)
                    ? $model->getAttributeLabel($name)
                    : '';
            }
            if (!isset($column['labelFormat'])) {
                $column['labelFormat'] = 'text';
            }
            if (!isset($column['format'])) {
                $column['format'] = 'text';
            }
            if (!isset($column['class'])) {
                $column['class'] = ytg_Core::$app->prefix . '-column-' . $name;
            }

            $columns[$name] = $column;
        }
        $this->columns = $columns;

        if (!is_array($this->defaultSort)) {
            $this->defaultSort = (array) $this->defaultSort;
        }

        $sort = $this->defaultSort;
        if (!isset($sort[1])) {
            $sort[1] = 'ASC';
        }

        $this->setSort($sort);

        // Init counts
        $this->totalCount = $this->getModel()->count($this->condition);
        $this->count = $this->getModel()->count($this->_getActiveFilter());
        $this->pageCount = ceil($this->count / $this->pageSize);
    }

    public function assignParams(array $params)
    {
        // Init sort
        if (isset($params[$this->sortParameter])) {
            $sort = $params[$this->sortParameter];
            $sortDirection = 'ASC';
            if ('-' == substr($sort, -1)) {
                $sort = (substr($sort, 0, -1));
                $sortDirection = 'DESC';
            }

            if (isset($this->columns[$sort])) {
                $this->setSort(array($sort, $sortDirection));
            }

            // Reset page number on sort change
            $this->page = 1;
        }

        // Init page number
        if ($this->count) {
            if (isset($params[$this->pageParameter])) {
                $this->page = (int) $params[$this->pageParameter];
            }

            if ($this->page > $this->pageCount) {
                $this->page = $this->pageCount;
            } else if ($this->page < 1) {
                $this->page = 1;
            }
        } else {
            $this->page = 1;
        }

        return $this;
    }

    public function setSort($value)
    {
        if (is_array($this->sort) && isset($this->columns[$this->sort[0]])) {
            unset($this->columns[$this->sort[0]]['sortDirection']);
        }

        $this->sort = $value;

        if (is_array($this->sort) && isset($this->columns[$this->sort[0]])) {
            $this->columns[$this->sort[0]]['sortDirection'] = $this->sort[1];
        }

        return $this;
    }

    /**
    * Returns model object for $modelClass
    *
    * @returns ytg_Framework_Db_ActiveRecord model object
    */
    public function getModel()
    {
        return ytg_Core::model($this->modelClass);
    }

    public function getRows()
    {
        // Prepare order
        if ($this->sort) {
            $order = $this->sort;
            if (isset($this->columns[$order[0]]['sort'])
                && $this->columns[$order[0]]['sort']
            ) {
                $sortConfig = $this->columns[$order[0]]['sort'];
                $order = is_array($sortConfig)
                    ? $sortConfig[$order[1]]
                    : $sortConfig . ' ' . $order[1];
            } else {
                if (is_array($order)) {
                    $order[0] = "`{$order[0]}`";
                }
            }
            if (is_array($order)) {
                $order = implode(' ', $order);
            }
        } else {
            $order = NULL;
        }

        // Prepare limit
        $limit = array(
            $this->pageSize * ($this->page-1),
            $this->pageSize
        );

        $config = $this->queryConfig;
        $config['order'] = $order;
        $config['limit'] = $limit;

        return $this->getModel()->findAll($this->_getActiveFilter(), $config);
    }

    protected function _getActiveFilter()
    {
        return $this->getModel()->joinWhereConditions(array(
            $this->condition,
            $this->filter,
        ));
    }

    public function createQuery(array $params=array())
    {
        $result = array();

        // Page
        $value = isset($params['page'])
            ? $params['page']
            : $this->page;
        if ($value > 1 || '{value}' == $value) {
            $result[$this->pageParameter] = $value;
        }

        // Sort
        $value = isset($params['sort'])
            ? $params['sort']
            : $this->sort;
        if ($this->defaultSort != $value) {
            $sortParam = $value[0];
            if (isset($value[1]) && 'DESC' == $value[1]) {
                $sortParam .= '-';
            }

            $result[$this->sortParameter] = $sortParam;
        }

        return http_build_query(array_merge($this->urlParams, $result), '_', '&');
    }

    public function cellValue(ytg_Framework_Db_ActiveRecord $model, $name)
    {
        return $model->hasAttribute($name) ||  $model->hasProperty($name)
            ? $model->$name
            : NULL;
    }
}