<?php
ytg_Core::load('Framework_Validator');

class ytg_Framework_Validator_Unique extends ytg_Framework_Validator
{
    /**
     * @var string the name of the ActiveRecord class that should be used to validate the existence
     * of the current attribute value. It not set, it will use the ActiveRecord class of the attribute being validated.
     * @see targetAttribute
     */
    public $targetClass;
    /**
     * @var string|array the name of the ActiveRecord attribute that should be used to
     * validate the existence of the current attribute value. If not set, it will use the name
     * of the attribute currently being validated. You may use an array to validate the existence
     * of multiple columns at the same time. The array values are the attributes that will be
     * used to validate the existence, while the array keys are the attributes whose values are to be validated.
     * If the key and the value are the same, you can just specify the value.
     */
    public $targetAttribute;
    /**
     * @var string|array|\Closure additional filter to be applied to the DB query used to check the existence of the attribute value.
     * This can be a string or an array representing the additional query condition (refer to [[\yii\db\Query::where()]]
     * on the format of query condition), or an anonymous function with the signature `function ($query)`, where `$query`
     * is the [[\yii\db\Query|Query]] object that you can modify in the function.
     */
    public $filter;

    /**
     * @inheritdoc
     */
    public function init()
    {
        parent::init();
        if ($this->message === null) {
            $this->message = '{attribute} "{value}" has already been taken.';
        }
    }

    /**
     * @inheritdoc
     */
    public function validateAttribute($model, $attribute)
    {
        $targetAttribute = $this->targetAttribute === null ? $attribute : $this->targetAttribute;

        $targetClass = $this->targetClass === null ? get_class($model) : $this->targetClass;

        $static = ytg_Core::model($targetClass);

        $value = $model->$attribute;

        $filter = is_callable($this->filter)
            ? call_user_func($this->filter, $model, $attribute)
            : $this->filter;

        $where = $static->joinWhereConditions(array(
            array($targetAttribute => $value),
            $filter,
        ));

        $result = $static->findByWhereCondition($where, array('limit' => 1));

        if (!$result || (!$model->isNewRecord && $model->equals($result[0]))) {
            return;
        }

        $this->addError($model, $attribute, $this->message);
    }
}
