<?php
ytg_Core::load('Framework_Model');

class ytg_Framework_Model_Form_Permanent extends ytg_Framework_Model
{
    const PERMANENT_SCENARIO = 'permanent';

    /**
    * @var ytg_Framework_Component_OptionsAbstract
    */
    public $io;

    public function permanentAttributes()
    {
        if (!isset($scenarios[self::PERMANENT_SCENARIO])) {
            return $this->safeAttributes();
        }

        $result = array();
        foreach ($scenarios[self::PERMANENT_SCENARIO] as $attribute) {
            if ($attribute[0] !== '!') {
                $result[] = $attribute;
            }
        }

        return $result;
    }

    public function refresh($attributes = NULL)
    {
        if (is_null($attributes)) {
            $attributes = $this->permanentAttributes();
        }

        $this->beforeRefresh($attributes);

        foreach ($attributes as $attribute) {
            $this->$attribute = $this->io->get(
                $this->getPermanentKey($attribute));
        }

        $this->afterRefresh($attributes);

        return $this;
    }

    public function save($runValidation = TRUE, $attributes = NULL)
    {
        if (is_null($attributes)) {
            $attributes = $this->permanentAttributes();
        }

        if ($runValidation && !$this->validate($attributes)) {
            return FALSE;
        }

        $this->beforeSave($attributes);

        foreach ($attributes as $attribute) {
            $this->io->set($this->getPermanentKey($attribute),
                $this->$attribute);
        }

        $this->afterSave($attributes);

        return $this;
    }

    public function getPermanentKey($attribute)
    {
        // Extensions

        return $attribute;
    }

    //
    // Events
    //

    public function beforeRefresh(&$attributes)
    {

    }

    public function afterRefresh($attributes)
    {

    }

    public function beforeSave(&$attributes)
    {

    }

    public function afterSave($attributes)
    {

    }
}