<?php

class ytg_Framework_Helper_Filter
{
    public static function stripNewLines($value)
    {
        if (is_array($value)) {
            return $value;
        }

        return str_replace(array("\r", "\n"), '', $value);
    }

    public static function filterList($value, array $itemFilters = array())
    {
        if ('' == $value) {
            return NULL;
        }

        $value = explode("\n", $value);
        foreach ($value as $i=>$line) {
            $line = trim($line);
            if ('' == $line) {
                unset($value[$i]);
                continue;
            }

            foreach ($itemFilters as $callable) {
                $line = ytg_Core::call($callable, array($line));
            }

            $value[$i] = $line;
        }
        $value = array_unique($value);

        return ($value? implode("\n", $value): NULL);
    }
}
