<?php
ytg_Core::load('Framework_Object');

abstract class ytg_Framework_Db_Schema extends ytg_Framework_Object
{
    /**
     * The followings are the supported abstract column data types.
     */
    const TYPE_PK = 'pk';
    const TYPE_BIGPK = 'bigpk';
    const TYPE_STRING = 'string';
    const TYPE_TEXT = 'text';
    const TYPE_SMALLINT = 'smallint';
    const TYPE_INTEGER = 'integer';
    const TYPE_BIGINT = 'bigint';
    const TYPE_FLOAT = 'float';
    const TYPE_DOUBLE = 'double';
    const TYPE_DECIMAL = 'decimal';
    const TYPE_DATETIME = 'datetime';
    const TYPE_TIMESTAMP = 'timestamp';
    const TYPE_TIME = 'time';
    const TYPE_DATE = 'date';
    const TYPE_BINARY = 'binary';
    const TYPE_BOOLEAN = 'boolean';
    const TYPE_MONEY = 'money';

    static protected $_tables = array();

    static public function getTableSchema($name)
    {
        return isset(self::$_tables[$name])
            ? self::$_tables[$name]
            : NULL;
    }

    static public function loadTableSchema($name, array $config)
    {
        $config['name'] = $name;
        if (!isset($config['fullName'])) {
            $config['fullName'] = self::composeFullTableName($name);
        }

        if (!isset($config['columns']) || !is_array($config['columns'])) {
            throw new Exception('Columns config should be provided.');
        }
        $columns = $config['columns'];
        unset($config['columns']);

        $result = ytg_Core::create('Framework_Db_Schema_Table', $config);

        foreach ($columns as $colName => $colConfig) {
            $colConfig['name'] = $colName;
            /**
            * @var ytg_Framework_Db_Schema_Column
            */
            $column = ytg_Core::create('Framework_Db_Schema_Column', $colConfig);

            if ($column->isPrimaryKey) {
                $result->primaryKey[] = $colName;
            }

            if ($column->autoIncrement && '' == $result->sequenceName) {
                $result->sequenceName = $colName;
            }

            $result->columns[$colName] = $column;
        }

        self::$_tables[$name] = $result;

        return $result;
    }

    static public function hasTableSchema($name)
    {
        return isset(self::$_tables[$name]);
    }

    static public function composeFullTableName($name)
    {
        global $wpdb;

        return $wpdb->prefix . ytg_Core::$app->prefix . '_' . $name;
    }
}