<?php
ytg_Core::load('Framework_Object');

/**
 * Class ytg_Framework_Controller
 * @property string $controllerName
 * @property string $actionName
 */
abstract class ytg_Framework_Controller extends ytg_Framework_Object
{
    protected $_defaultAction = 'index';

    protected $_controllerName;
    protected $_actionName;
    protected $_params;

    public $layoutTemplate;

    public $layoutParams = array();

    public function dispatch($controllerName, $actionName=NULL,
        array $params=array())
    {
        $this->_controllerName = $controllerName;
        $this->_actionName = !is_null($actionName)
            ? $actionName
            : $this->_defaultAction;
        $this->_params = $params;

        $method = 'action' . ucfirst($this->_actionName);
        if (!method_exists($this, $method)) {
            throw new ytg_Framework_Controller_Exception(
                "Action '{$this->_actionName}' not found.");
        }
        // Map params
        try {
            $params = ytg_Core::mapMethodParams(get_class($this), $method,
                $this->_params);
        } catch (Exception $e) {
            throw new ytg_Framework_Controller_Exception($e->getMessage());
        }

        return call_user_func_array(array($this, $method), $params);
    }

    //
    // Params
    //

    public function getParams()
    {
        return $this->_params;
    }

    public function getParam($key)
    {
        return $this->hasParam($key)
            ? $this->_params[$key]
            : NULL;
    }

    public function setParams(array $value)
    {
        $this->_params = $value;

        return $this;
    }

    public function setParam($key, $value)
    {
        $this->_params[$key] = $value;

        return $this;
    }

    public function hasParam($key)
    {
        return array_key_exists($key, $this->_params);
    }
    //
    // Render
    //

    public function render($view, array $params = array())
    {
        $result = ytg_Core::$app->view->render($view, $params, $this);

        if (!is_null($this->layoutTemplate)) {
            $params = $this->layoutParams;
            $params['content'] = $result;

            $result = ytg_Core::$app->view->render(
                'layouts/' . $this->layoutTemplate, $params, $this);
        }

        return $result;
    }

    //
    // Getters and setters
    //

    /**
     * @return string
     */
    public function getControllerName()
    {
        return $this->_controllerName;
    }

    /**
     * @return string
     */
    public function getActionName()
    {
        return $this->_actionName;
    }
}

class ytg_Framework_Controller_Exception extends Exception
{

}