<?php
ytg_Core::load('Framework_Component');

/**
 * Helpers:
 * @method string adminUrl(array|string $url)
 * @method string escape(string $text)
 * @method string format(string $text, string $format)
 * @method string pluginUrl(string $path)
 * @method wysiwygEditor(string $content, string $id, array $options)
 */

class ytg_Framework_Component_View extends ytg_Framework_Component
{
    public $templateFolder = 'views';

    public $context;

    protected $_helpers = array();

    protected $_viewStack = array();

    public function render($view, $params = array(), $context = null)
    {
        $viewFile = $this->findViewFile($view, $context);
        return $this->renderFile($viewFile, $params, $context);
    }

    protected function findViewFile($view, $context = null)
    {
        return ytg_Core::$app->basePath . "/app/{$this->templateFolder}/{$view}.php";
    }

    public function viewFileExists($view, $context = null)
    {
        $file = $this->findViewFile($view, $context);

        return is_file($file);
    }

    public function renderFile($viewFile, $params = array(), $context = null)
    {
        $oldContext = $this->context;
        if ($context !== null) {
            $this->context = $context;
        }

        $output = $this->renderPhpFile($viewFile, $params);

        $this->context = $oldContext;

        return $output;
    }

    /**
     * Renders a view file as a PHP script.
     *
     * This method treats the view file as a PHP script and includes the file.
     * It extracts the given parameters and makes them available in the view file.
     * The method captures the output of the included view file and returns it as a string.
     *
     * This method should mainly be called by view renderer or [[renderFile()]].
     *
     * @param string $_file_ the view file.
     * @param array $_params_ the parameters (name-value pairs) that will be extracted and made available in the view file.
     * @return string the rendering result
     */
    public function renderPhpFile($_file_, $_params_ = array())
    {
        ob_start();
        ob_implicit_flush(false);
        extract($_params_, EXTR_OVERWRITE);
        require $_file_;

        return ob_get_clean();
    }

    //
    // Layout handling
    //

    public function beginContent($view, array $params = array())
    {
        $this->_viewStack[] = compact('view', 'params');

        ob_start();
        ob_implicit_flush(false);
    }

    public function endContent()
    {
        extract(array_pop($this->_viewStack));

        $params['content'] = ob_get_clean();

        echo $this->render($view, $params);
    }

    //
    // Helpers
    //

    function getHelper($name)
    {
        $name = ucfirst($name);

        if (!isset($this->_helpers[$name])) {
            $this->_helpers[$name] = ytg_Core::create(
                ytg_Core::fallback("Component_View_Helper_{$name}"),
                array('view' => $this));
        }

        return $this->_helpers[$name];
    }

    public function __call($method, $params)
    {
        $helper = $this->getHelper($method);
        if ($params) {
            return call_user_func_array(array($helper, '__invoke'), $params);
        } else {
            return $helper;
        }
    }
}