<?php
ytg_Core::load('Framework_Component');

class ytg_Framework_Component_PostTypes extends ytg_Framework_Component
{
    public $excludeContentTypes = array('attachment');

    public $listValueProperty = 'singular_name';
    public $listValueLowercase = TRUE;

    protected $_contentTypes;
    protected $_list;

    public function getContentTypes()
    {
        if (is_null($this->_contentTypes)) {
            $this->_contentTypes = array_diff(
                get_post_types(array('public' => TRUE)),
                $this->excludeContentTypes
            );
        }

        return $this->_contentTypes;
    }

    public function getList()
    {
        if (is_null($this->_list)) {
            $property = $this->listValueProperty;

            $this->_list = array();

            foreach ($this->getContentTypes() as $name) {
                $type = get_post_type_object($name);


                $label = $type->labels->$property;
                if ($this->listValueLowercase) {
                    $label = strtolower($label);
                }

                $this->_list[$name] = $label;
            }
        }

        return $this->_list;
    }
}