<?php
ytg_Core::load('Framework_Component_OptionsAbstract');

class ytg_Framework_Component_Cache
    extends ytg_Framework_Component_OptionsAbstract
{
    public $defaultsConfigPath = 'cache/default';

    public $defaultExpiration = 86400;

    public function get($name, $default=NULL)
    {
        $result = get_transient($this->prefix . $name);

        if (FALSE === $result && is_null($default)) {
            $result = ytg_Core::$app->getConfigValue(
                "{$this->defaultsConfigPath}/{$name}");
        }

        return $result;
    }

    public function set($name, $value, $expiration = NULL)
    {
        if (is_null($expiration)) {
            $expiration = $this->defaultExpiration;
        }

        set_transient($this->prefix . $name, $value, $expiration);

        return $this;
    }

    public function delete($name)
    {
        return delete_transient($this->prefix . $name);
    }
}