"use strict";

jQuery(function($) {
    function hideHelpTooltip() {
        $('.ytg-help-block').each(function() {
            var $this = $(this);
            if ($this.is(':visible')) {
                $this.fadeOut(function() {
                    var $body = $this.find('.ytg-help-body');
                    $body.attr('data-html', $body.html());
                    $body.empty();
                })
            }
        });

        $('#ytg-help-bkg').fadeOut();
    }

    function showHelpTooltip(identifier) {
        hideHelpTooltip();
        $('#ytg-help-bkg').fadeIn();

        var $block = $('#ytg-help-block-' + identifier);
        var $body = $block.find('.ytg-help-body');
        var html = $body.attr('data-html');
        if ('' != html) {
            $body.html(html);
        }
        $block.slideDown('fast');
    }

    $('.ytg-help-link').click(function() {
        showHelpTooltip($(this).attr('data-identifier'));
        return false;
    });

    $('#ytg-help-bkg, .ytg-help-close').click(function() {
        hideHelpTooltip();
        return false;
    });
});