"use strict";

jQuery(function($) {
    function updateScreenSetting(name, value) {
        $.ajax({
            type: 'POST',
            url: ajaxurl + '?action=ytg&controller=admin&controllerAction=updateScreenSetting',
            data: {
                name: name,
                value: value
            },
            dataType: 'json',
            success: function(data) {

            },
            error: function(xhr, textStatus, errorThrown) {
                if ('abort' == textStatus) {
                    return;
                }
                //alert('AJAX error!');
            },
            complete: function() {

            }
        });
    }

    function initCategoryAdder() {
        // Add new category toggle
        $('.ytg-button-category-adder-toggle').click(function() {
            var $adder = $(this).closest('.ytg-category-adder')
                .find('.ytg-category-adder-group');

            if (!$adder.is(':visible')) {
                $adder.slideDown('fast');
                $adder.find('.ytg-input-name').focus();
            } else {
                $adder.slideUp('fast');
            }

            return false;
        });

        $('.ytg-category-adder .ytg-input-name').keypress(function() {
            if (13 == event.which) {
                event.preventDefault();
                $('.ytg-category-adder .ytg-category-adder-submit').click();
            }
        });

        $('.ytg-category-adder .ytg-category-adder-submit').click(function() {
            var $this = $(this);
            var $adder = $('.ytg-category-adder');

            //$adder.find('.ytg-error-notice').empty();

            var data = {
                name: $.trim($adder.find('.ytg-input-name').val()),
                parentId: $adder.find('.ytg-input-parentId').val()
            };

            if ('' == data.name) {
                $adder.find('.ytg-input-name').focus();
                alert('Please enter a category name');

                return;
            }

            $adder.find('.ytg-ajax-indicator').css('visibility', 'visible');
            $this.prop('disabled', true);

            $.ajax({
                type: 'POST',
                url: ajaxurl + '?action=ytg&controller=admin&controllerAction=addCategory',
                data: data,
                dataType: 'json',
                success: function(data) {
                    if ('error' == data.status) {
                        alert('Error adding category: ' + data.errorMessage);
                        return;
                    }

                    $('.ytg-category-checklist')
                        .html(data.categoryList)
                        .scrollTo('[value="' + data.category.term_id + '"]',
                            'fast',
                            {
                                axis: 'y',
                                over: {top: -0.25}
                            });

                    $('.ytg-category-adder .ytg-input-name').val('');

                    $('.ytg-category-adder .ytg-parent-category-dropdown')
                        .html(data.parentCategoryDropdown);
                },
                error: function(xhr, textStatus, errorThrown) {
                    if ('abort' == textStatus) {
                        return;
                    }
                    alert('AJAX error!');
                },
                complete: function() {
                    $adder.find('.ytg-ajax-indicator').css('visibility', 'hidden');
                    $this.prop('disabled', false);
                }
            });
        });
    }

    window.ytg_host = {
        init: function($elem) {
            $elem.find('a[data-ytg-confirm]').click(function() {
                return confirm($(this).attr('data-ytg-confirm'));
            });
            $elem.find('[data-ytg-alert]').click(function() {
                alert($(this).attr('data-ytg-alert'));
            });

            $elem.find('[data-ytg-dialog]').click(function() {
                var $this = $(this);
                tb_show($this.attr('data-ytg-dialog'), $this.attr('data-ytg-href'));

                return false;
            });

            // Grid pagination
            $elem.find('.ytg-pagination .current-page').change(function() {
                var $this = $(this);
                window.location.href = $this.attr('data-url-template').replace(
                    '%7Bvalue%7D', $this.val());
            });

            // Select all
            $elem.find('input[data-ytg-select-all]').click(function() {
                var $this = $(this);
                $($this.attr('data-ytg-select-all') + ' input[type="checkbox"]').prop(
                    'checked', $this.prop('checked'));
            });

            // Switch template previews
            $elem.find('.ytg-input-template').change(function() {
                var $preview = $('#ytg-template-preview');

                $preview.attr('src', $preview.attr('data-url-template').replace(
                    '%7Bid%7D', $(this).val()));
            });

            // Category list resizable
            $elem.find('.ytg-category-checklist-container').each(function() {
                var $this = $(this);

                $this.resizable({
                    handles: 's',
                    minHeight: parseInt($this.css('min-height')),
                    stop: function(event, ui) {
                        updateScreenSetting('categoryChecklistHeight',
                            ui.element.height());
                    }
                });
            });

            // Template preivew list resizable
            $elem.find('.ytg-template-preview-container').each(function() {
                var $this = $(this);

                $this.resizable({
                    handles: 's',
                    minHeight: parseInt($this.css('min-height')),
                    helper: 'ytg-ui-resizable-helper',
                    stop: function(event, ui) {
                        updateScreenSetting('templatePreviewHeight',
                            ui.element.height());
                    }
                });
            });
        },

        initDialog: function($elem) {
            $elem.find('form').submit(function(e) {
                var $this = $(this);

                $('.ytg-dialog .ytg-ajax-indicator').css('visibility', 'visible');
                $('.ytg-dialog button[type="submit"]').prop('disabled', true);

                $.ajax({
                    type: 'POST',
                    url: ytg_scriptData.formSubmitUrlBase + $this.attr('data-id'),
                    data: {
                        form: $this.serialize(),
                        gridParams: ytg_scriptData.gridParams
                    },
                    dataType: 'json',
                    success: function(data) {
                        if ('success' == data.status) {
                            $('.ytg-grid-container').html(data.grid);
                            window.ytg_host.init($('.ytg-grid-container'));

                            var $p = $('<p />').text(data.message);
                            var $notice = $('<div class="notice notice-success is-dismissible"></div>');
                            $notice.append($p);

                            $('#ytg-admin > .notice').remove();
                            $('#ytg-messages').empty().append($notice);

                            window.ytg_host.makeNoticesDismissible($notice);

                            tb_remove();
                        } else {
                            // Error
                            $('.ytg-dialog .ytg-ajax-indicator').css('visibility', 'hidden');
                            alert(data.error);
                        }
                    },
                    error: function(xhr, textStatus, errorThrown) {
                        if ('abort' == textStatus) {
                            return;
                        }
                        alert('AJAX error!');
                    },
                    complete: function() {
                        $('.ytg-dialog .ytg-ajax-indicator').css('visibility', 'hidden');
                        $('.ytg-dialog button[type="submit"]').prop('disabled', false);
                    }
                });

                e.preventDefault();
                return false;
            });
        },

        makeNoticesDismissible: function ($elem) {
            $elem.each(function() {
                var $el = $( this ),
                    $button = $( '<button type="button" class="notice-dismiss"><span class="screen-reader-text"></span></button>' ),
                    btnText = commonL10n.dismiss || '';

                // Ensure plain text
                $button.find( '.screen-reader-text' ).text( btnText );
                $button.on( 'click.wp-dismiss-notice', function( event ) {
                    event.preventDefault();
                    $el.fadeTo( 100, 0, function() {
                        $el.slideUp( 100, function() {
                            $el.remove();
                        });
                    });
                });

                $el.append( $button );
            });
        }
    };

    // Init common stuff
    window.ytg_host.init($('html'));

    $('.ytg-field-keyword .ytg-form-control').on('change keyup', function() {
        if ('' == $.trim($(this).val())) {
            $('.ytg-field-negativeKeywords .ytg-form-control').addClass('disabled');
            $('.ytg-field-negativeKeywords .ytg-no-effect').show();
        } else {
            $('.ytg-field-negativeKeywords .ytg-form-control').removeClass('disabled');
            $('.ytg-field-negativeKeywords .ytg-no-effect').hide();
        }
    });

    if ($('#ytg-form-admin').length) {
        // Main form
        initCategoryAdder();

        if ($('.ytg-field-postCategories input[type="checkbox"]:checked').length <= 1) {
            $('.ytg-button-generate').click(function (e) {
                // Check if 2+ category selected

                var count = $('.ytg-field-postCategories input[type="checkbox"]:checked').length;
                if (count >= 2) {
                    if (!confirm('Warning: You are posting to ' + count.toString() + ' categories. Click "OK" to continue or "Cancel".')) {
                        return false;
                    }
                }
            });
        }

        $('#ytg-btn-allowTextSpinningOff').click(function() {
            $('#ytg-input-allowTextSpinningOff').val('1');
            $('#ytg-form-admin').submit();
        });

        $('.ytg-searchMode-option').click(function() {
            var value = $(this).val();

            $('.ytg-searchMode-specific').each(function() {
                var $this = $(this);

                if (value == $this.attr('data-value')) {
                    if (!$this.is(':visible')) {
                        $this.slideDown();
                    }
                } else {
                    if ($this.is(':visible')) {
                        $this.slideUp();
                    }
                }
            });
        });

    } else if ($('#ytg-form-options').length) {
        // Options form
        $('#ytg-input-displayCloakLinks').click(function () {
            $('#ytg-input-displayCloakingDirectory').prop('disabled',
                !$(this).prop('checked'));
        });

    } else if ($('#ytg-form-channel').length) {
        // Channel form
        initCategoryAdder();

        if ($('.ytg-category-checklist input[type="checkbox"]:checked').length <= 1) {
            $('#ytg-form-channel').submit(function (e) {
                // Check if 2+ category selected

                var count = $('.ytg-category-checklist input[type="checkbox"]:checked').length;
                if (count >= 2) {
                    if (!confirm('Warning: You are posting to ' + count.toString() + ' categories. Click "OK" to continue or "Cancel".')) {
                        return false;
                    }
                }
            });
        }

    } else if ($('#ytg-form-cpanel').length) {
        // cPanel form
        $('.ytg-form-cpanel .ytg-toggle').click(function() {
            var $internal = $('.ytg-form-cpanel .ytg-internal');

            if ($internal.is(':visible')) {
                $(this).text('Show');
                $internal.slideUp();
            } else {
                $(this).text('Hide');
                $internal.slideDown();
            }
        });

    } else if ($('.ytg-metabox').length) {
        // Metaboxes
        $('.ytg-metabox button[type="submit"]').click(function() {
            $('#publishing-action .spinner').css('visibility', 'visible');
            //$(this).next('.ajax-loading').css('visibility', 'visible');

            $('#post button[type="submit"], #post input[type="submit"]').prop('disable', true)
                .addClass('disabled')
                .filter('.button-primary').addClass('button-primary-disabled');

            // Stop autosave
            if (wp.autosave) {
                wp.autosave.server.suspend();
            }

            $(window).off('beforeunload.edit-post');

            //$('#post').submit();
        });
    }
});