<p>What is WP Cron, why it's great, what are its limitations, and how to fix
    them:</p>

<p>The plugin can &quot;spy&quot; on YouTube channels of your choice and add
    create video posts from new videos it finds.</p>

<p>You can schedule this to run, say, once a day, once every seven days etc.</p>

<p>The way WordPress schedules functions like this is with something called
    &quot;WP Cron.&quot; This function can be set to do things in the future.
    You set it and forget it. One limitation of the function is that it requires
    &quot;something&quot; to &quot;wake it up&quot; and run it. These can be
    things like:</p>

<ul>
    <li>You login to your site as admin</li>
    <li>Someone visits your site</li>
    <li> A search engine spider visits your site</li>
</ul>

<p>If you set the plugin to search for new videos in YouTube channels, say,
    every 7 days, and nothing of the above happens after those 7 days to wake up
    WP Cron, then the plugin won't be able to search for new videos. The new
    &quot;search&quot; will happen once WP Cron is ran again (once you login to
    your site, or once someone or something visits your site). If your site gets
    visited often enough, then you don't need to do anything. If you think your
    site will not be getting visited often enough, don't worry, as there are
    three solutions to this:</p>

<p>1 - Easiest of all: If your host uses cPanel, the plugin can create a
    &quot;cron job&quot; for you, on your server, automatically.</p>

<?php
$domain = parse_url(site_url(), PHP_URL_HOST);
?>
<p>You can find out if your host uses cPanel by visiting
    <a href="http://<?php echo $this->escape($domain); ?>/cpanel" target="_blank"><?php echo $this->escape($domain); ?>/cpanel</a>.</p>

<p>If your hosting account uses cPanel (more than 90% of them do), just enter
    your cPanel username and password in the fields within the plugin. Please
    note that the plugin, which is already installed on your server, will
    communicate with your hosting account's cPanel, directly, to run the cron
    job. AT NO POINT WILL YOUR CPANEL USERNAME OR PASSWORD BE EXPOSED TO ANYONE.
    Sorry for the caps - we just want to make it crystal clear that your info
    is safe. :-)</p>

<p>2 - For more advanced users: If you instead want to create a cron job
    manually, you can enter the following line in the &quot;command&quot; field
    for the cron job:</p>

<pre>wget -q -O - <?php echo $this->escape(site_url('', 'http')); ?>/wp-cron.php</pre>

<p>Like so:<br>
    <img src="<?php echo $this->escape($this->pluginUrl('assets/images/help/add-cron-job.png')); ?>"></p>

<p>3 - A free solution for those who aren't tech-savy: Create a free account on
    <a href="http://mywebcron.com" target="_blank">MyWebCron.com</a>. This is a
    service that will &quot;ping&quot; your site, say, once a day (you control
    that), and make sure that WP cron can do its job and fetch your videos. Just
    signup for the FREE plan, and then set up your cron job. The images below
    should help:</p>

<p>
    <img src="<?php echo $this->escape($this->pluginUrl('assets/images/help/mywebcron1.jpg')); ?>">
    <br>
    <img src="<?php echo $this->escape($this->pluginUrl('assets/images/help/mywebcron2.jpg')); ?>">
</p>

<p>Copy and paste the following line in the URL field of MyWebCron.com:</p>

<pre><?php echo site_url('', 'http'); ?>/wp-cron.php</pre>