<?php
/** @var string[] $params */
/** @var ytg_Framework_Widget_Grid $grid */

if (!isset($page)) {
    $page = $_GET['page'];
}

$grid = ytg_Core::create('Framework_Widget_Grid', array(
    'modelClass' => 'Model_Channel',
    'columns' => array(
        'name' => array(
            'label' => 'Name',
        ),
        'tools',
    ),
    'defaultSort' => array('name', 'ASC'),
    'urlParams' => array(
        'page' => $page,
    ),
    'tableClass' => 'widefat fixed striped ytg-grid ytg-grid-channel',
    'templateDirectory' => 'channel/index/grid',

    //'pageSize' => 2,
));

$grid->assignParams($_GET);
?>

<div class="tablenav top">
    <div class="ytg-toolbar">
        <a class="button button-primary ytg-button-add"
           href="<?php echo $this->escape($this->adminUrl(array(
               'action' => 'add',
           ))); ?>"
        >
            Add New Channel
        </a>
    </div>
    <?php echo $this->render('_grid/pagination', compact('grid')); ?>
</div>

<?php echo $this->render('_grid/grid', compact('grid')); ?>

<div class="tablenav bottom">
    <?php echo $this->render('_grid/pagination', compact('grid')); ?>
</div>