<?php
/**
 * @var $this ytg_Framework_Component_View
 * @var $model ytg_Model_Form_Admin
 * @var $preview array
 */
$formName = $model->formName();

$value = (array) $model->videoIds;
?>
<div class="notice notice-warning ytg-preview-notice">
    <p><strong>Please note:</strong> The preview function will show you the videos, as they would be returned
        by YouTube. This function doesn't take into account filtering like &quot;minimum views&quot;, because
        this function isn't available via the YouTube Search API. If you want the &quot;minimum views&quot;
        filter to be used, please click the blue "Generate Video Posts" button. Furthermore, the &quot;fetch X
        total videos&quot; setting is ignored in preview mode. Instead, all the videos that you select will get
        added.</p>
</div>
<div class="ytg-preview-container">
    <div class="ytg-preview-buttons ytg-button-row ytg-top">
        <button type="submit"
                class="button-secondary action-button"
                name="action"
                value="add-selected"
        >
            Add Selected
        </button>
        <?php /*
        <span class="ytg-help-link-container">
            (<a href="#" class="ytg-help-link" data-identifier="add-selected">help</a>)
        </span>
        */ ?>
    </div>
    <table id="ytg-preview"
        class="widefat fixed ytg-preview"
    >
        <thead>
        <tr>
            <th class="ytg-column-select">
                <input type="checkbox"
                       data-ytg-select-all="#ytg-preview tbody [data-ytg-duplicate='false'] .ytg-column-select"
                />
            </th>
            <th class="ytg-column-videoId"><span>Video ID</span></th>
            <th class="ytg-column-title"><span>Title</span></th>
            <th class="ytg-column-thumbnail"></th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($preview as $key=>$item): ?>
            <?php
            $url = "https://www.youtube.com/watch?v={$item['videoId']}";
            $thumbUrl = "//img.youtube.com/vi/{$item['videoId']}/1.jpg"
            ?>
            <tr data-ytg-duplicate="<?php echo $item['duplicate']? 'true' : 'false' ?>">
                <td scope="row" class="ytg-column-select">
                    <input type="checkbox"
                           id="ytg-input-videoIds-<?php echo $this->escape($item['videoId']); ?>"
                           name="<?php echo $formName; ?>[videoIds][]"
                           value="<?php echo $this->escape($item['videoId']); ?>"
                           <?php if ($item['duplicate']): ?>disabled="disabled"<?php endif; ?>
                           <?php if (!$item['duplicate'] && in_array($item['videoId'], $value)): ?>checked="checked"<?php endif; ?>
                    >
                </td>
                <td class="ytg-column-videoId">
                    <label class="ytg-label-videoId"
                           for="ytg-input-videoIds-<?php echo $this->escape($item['videoId']); ?>"
                    >
                        <?php echo $this->escape($item['videoId']); ?>
                    </label>
                </td>
                <td class="ytg-column-title">
                    <span>
                        <a href="<?php echo $this->escape($url); ?>" target="_blank">
                            <?php echo $this->escape($item['title']); ?>
                        </a>
                    </span>
                </td>
                <td class="ytg-column-thumbnail">
                    <a href="<?php echo $this->escape($url); ?>" target="_blank"
                    ><img class="ytg-preview-thumbnail"
                             src="<?php echo $this->escape($thumbUrl); ?>"
                        ></a>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
    <div class="ytg-preview-buttons ytg-button-row ytg-bottom">
        <button type="submit"
                class="button-secondary action-button"
                name="action"
                value="add-selected"
        >
            Add Selected
        </button>
        <?php /*
        <span class="ytg-help-link-container">
            (<a href="#" class="ytg-help-link" data-identifier="add-selected">help</a>)
        </span>
        */ ?>
    </div>
</div>