<?php
/**
 * @var $this ytg_Framework_Component_View
 * @var $model ytg_Component_Activate
 */

$this->context->layoutParams['title'] = 'Activate ' . ytg_Core::config('plugin/title');
$this->context->layoutParams['hideHeaderTabs'] = TRUE;

$formName = $model->formName();
?>
<div class="ytg-form-wrap ytg-form-activate">
    <h3>
        <span class="ytg-text">Please enter the delivery email address you used,
            when you ordered with JVZoo:</span>
    </h3>
    <form id="ytg-form-activate"
        action=""
        method="post"
    >
        <div class="ytg-form-activate-container">
            <?php
            $attribute = 'email';
            $id = "{$formName}-{$attribute}";
            ?>
            <div class="ytg-form-group ytg-field-<?php echo $attribute; ?>">
                <input type="text"
                       name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                       id="<?php echo $id; ?>"
                       class="ytg-form-control"
                       value="<?php echo $this->escape($model->$attribute); ?>"
                >

                <button type="submit"
                    class="button button-primary ytg-btn-submit"
                >
                    Activate
                </button>

                <div class="ytg-help-activation-email-container">
                    <img src="<?php echo $this->escape($this->pluginUrl('assets/images/activation-email-2.png')); ?>"
                         class="ytg-help-activation-email-image"
                    >
                </div>
            </div>
        </div>
    </form>
</div>

<?php
$helpPath = dirname(__FILE__) . "/{$this->context->actionName}/help/";

$tips = array(
);

foreach ($model->safeAttributes() as $attribute) {
    if ($model->getAttributeProperty($attribute, 'help')) {
        $tips[$attribute] = $model->getAttributeLabel($attribute);
    }
}

foreach ($tips as $id=>$label) {
    echo $this->render('_help/popup', array(
        'identifier' => $id,
        'title' => $label,
        'path' => $helpPath . $id . '.php',
    ));
}