<?php
ytg_Core::load('Framework_Validator');

class ytg_Validator_PostCategories extends ytg_Framework_Validator
{
    public function validateAttribute($model, $attribute)
    {
        $value = $model->$attribute;

        if (!is_array($value)) {
            $model->addError($attribute, "{attribute} is invalid");
        }

        foreach ($value as $id) {
            if (!$this->_isCategoryExist($id)) {
                $model->addError($attribute, "Post category ID '{$id}' does not exist");
            }
        }
    }

    protected function _isCategoryExist($id)
    {
        return (bool) get_term_by('id', $id, 'category');
    }
}