<?php
ytg_Core::load('Framework_Service');

class ytg_Service_Setup extends ytg_Framework_Service
{
    public function check()
    {
        /**
        * @var ytg_Framework_Component_Options
        */
        $options = ytg_Core::$app->options;

        $oldVer = $options->get('version');
        $newVer = ytg_Core::$app->version;

        if ($oldVer != $newVer) {
            if ('' == $oldVer) {
                $this->install();
            } else if (version_compare($oldVer, $newVer, '<')) {
                $this->update($oldVer);
            }

            $options->set('version', $newVer);
        }
    }

    public function run($oldVersion)
    {
        if (is_null($oldVersion)) {
            $this->install();
        } else {
            $this->update($oldVersion);
        }
    }

    public function install()
    {
        $prefix = $this->_getTablePrefix();

        // Template table
        if (!$this->_query("SHOW TABLES LIKE '{$prefix}_template'")) {
            // Structure
            $this->_query("CREATE TABLE `{$prefix}_template` (
                `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                `name` varchar(255) NOT NULL,
                `content` text NOT NULL,
                PRIMARY KEY (`id`),
                UNIQUE KEY `name` (`name`)
            ) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8");
            // Data
            $this->_query("INSERT INTO `{$prefix}_template` 
              VALUES ('1', '(default)', '"
                . esc_sql(ytg_Core::config('template/default/content'))
                . "')");
        }

        // Channel table
        $this->_query("CREATE TABLE IF NOT EXISTS `{$prefix}_channel` (
            `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
            `name` varchar(255) NOT NULL,
            `youtube_id` varchar(255) NOT NULL,
            `last_check_timestamp` int(11) unsigned NOT NULL,
            `template_id` bigint(20) unsigned DEFAULT NULL,
            `keyword` TEXT DEFAULT NULL,
            `negative_keywords` TEXT DEFAULT NULL,
            `post_type` VARCHAR(255) NOT NULL DEFAULT 'post',
            PRIMARY KEY (`id`),
            KEY `{$prefix}_channel_ibfk_1` (`template_id`),
            CONSTRAINT `{$prefix}_channel_ibfk_1` FOREIGN KEY (`template_id`) 
                REFERENCES `{$prefix}_template` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8");

        $this->_query("CREATE TABLE IF NOT EXISTS `{$prefix}_channel_category` (
            `channel_id` bigint(20) unsigned NOT NULL,
            `category_id` bigint(20) unsigned NOT NULL,
            PRIMARY KEY (`channel_id`,`category_id`),
            CONSTRAINT `{$prefix}_channel_category_ibfk_1` FOREIGN KEY (`channel_id`) 
                REFERENCES `{$prefix}_channel` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8");

        return $this;
    }

    public function update($oldVersion)
    {
        $prefix = $this->_getTablePrefix();

        if ('basic' == ytg_Core::config('edition') && version_compare($oldVersion, '1.0.3', '<=')) {
            ytg_Core::$app->options->set('generatorFeaturedImages', 1);
        }

        if (!$this->_query("SHOW TABLES LIKE '{$prefix}_template'")
            || !$this->_query("SHOW TABLES LIKE '{$prefix}_channel'")
            || !$this->_query("SHOW TABLES LIKE '{$prefix}_channel_category'")
        ) {
            return $this->install();
        }

        // 1.2
        if (version_compare($oldVersion, '1.2', '<')) {
            // Add Channel table columns
            try {
                $this->_query("ALTER TABLE `{$prefix}_channel` ADD COLUMN (
                    `keyword` TEXT DEFAULT NULL,
                    `negative_keywords` TEXT DEFAULT NULL,
                    `post_type` VARCHAR(255) NOT NULL DEFAULT 'post'
                )");
            } catch (ytg_Service_Setup_QueryException $e) {
                // Ignore dupliate column error
                if ('Duplicate column ' != substr($e->getMessage(), 0, 17)) {
                    throw $e;
                }
            }
        }

        return $this;
    }

    protected function _getTablePrefix()
    {
        return $GLOBALS['wpdb']->prefix . ytg_Core::$app->prefix;
    }

    public function activate()
    {
        $event = ytg_Core::$app->prefix . '_check_channels';

        if (!wp_next_scheduled($event)
            && 'pro' == ytg_Core::config('edition')
        ) {
            wp_schedule_event(time(), 'daily', $event);
        }

        $event = ytg_Core::$app->prefix . '-cron-verify';
        if (!wp_next_scheduled($event)) {
            wp_schedule_event(time(), $event, $event);
        }

        return $this;
    }

    public function deactivate()
    {
        wp_clear_scheduled_hook(ytg_Core::$app->prefix . '_check_channels');
        wp_clear_scheduled_hook(ytg_Core::$app->prefix . '-cron-verify');

        return $this;
    }

    protected function _query($sql)
    {
        global $wpdb;
        $wpdb->last_error = '';
        $oldShowErrors = $wpdb->show_errors;
        $wpdb->hide_errors();

        $result = $wpdb->query($sql);

        $wpdb->show_errors($oldShowErrors);

        if ('' != $wpdb->last_error) {
            throw new ytg_Service_Setup_QueryException($wpdb->last_error, $sql);
        }

        return $result;
    }
}

class ytg_Service_Setup_Exception extends Exception
{

}

class ytg_Service_Setup_QueryException extends ytg_Service_Setup_Exception
{
    public $sql;

    public function __construct($message, $sql = NULL)
    {
        parent::__construct($message);

        $this->sql = $sql;
    }
}