<?php
ytg_Core::load('Framework_Db_ActiveRecord');

/**
 * @property int $id
 * @property string $name
 * @property string $content
 */
class ytg_Model_Template extends ytg_Framework_Db_ActiveRecord
{
    public $table = 'template';

    public function schema()
    {
        return array(
            'columns' => array(
                'id' => array(
                    'type' => 'integer',
                    'isPrimaryKey' => TRUE,
                    'autoIncrement' => TRUE,
                    'allowNull' => FALSE,
                ),
                'name' => array(
                    'type' => 'string',
                    'size' => 255,
                    'allowNull' => FALSE,
                ),
                'content' => array(
                    'type' => 'string',
                    'allowNull' => FALSE,
                ),
            ),
        );
    }

    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }

    //
    // Requisites
    //

    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'name' => 'Template Name',
            'content' => 'Template Structure',
        );
    }

    public function rules()
    {
        return array(
            array('name', 'filter', 'filter' =>
                'stripslashes',
                'when' => array($this, '_allowEditingName'),
            ),
            array('name', 'trim', 'when' => array($this, '_allowEditingName')),
            array('name', 'filter',
                'filter' => array('ytg_Framework_Helper_Filter', 'stripNewLines'),
                'when' => array($this, '_allowEditingName')
            ),
            array('name', 'string', 'max' => 255, 'when' => array($this, '_allowEditingName')),
            array('name', 'compare', 'compareValue' => '(default)', 'operator' => '!=',
                'message' => 'The name "(default)" is reserved for the default template',
                'when' => array($this, '_allowEditingName')
            ),
            array('name', 'unique', 'when' => array($this, '_allowEditingName')),
            array('name', 'required', 'when' => array($this, '_allowEditingName')),

            array('content', 'filter', 'filter' => 'stripslashes'),
            array('content', 'trim'),
            array('content', 'string'),
            array('content', 'required'),
        );
    }

    public function loadDefaultValues($skipIfSet = true)
    {
        parent::loadDefaultValues($skipIfSet);

        if (!$skipIfSet || is_null($this->content)) {
            $this->content = ytg_Core::config('template/default/content');
        }
    }

    //
    // Conditions
    //

    public function _allowEditingName()
    {
        return 1 != $this->id;
    }

    //
    // List
    //

    public function getList()
    {
        $result = array();

        foreach ($this->findAll('`id` != 1', array('order' => 'name')) as $model) {
            $result[$model->id] = $model->name;
        }

        return $result;
    }

    //
    // Overrides
    //

    public function findOne($condition, array $config=array())
    {
        // Load default template by default
        if (is_null($condition) || '' == $condition) {
            $condition = 1;
        }

        return parent::findOne($condition, $config);
    }

    public function find($id=NULL)
    {
        $result = $this->findOne($id);

        if (!$result) {
            $result = $this->findOne(NULL);
        }

        return $result;
    }

    public function afterDelete()
    {
        global $wpdb;

        parent::afterDelete();

        if ($this->id == ytg_Core::$app->options->postTemplate) {
            ytg_Core::$app->options->postTemplate = 1;
        }

        $prefix = ytg_Core::$app->prefix;
        $wpdb->query("
            UPDATE `{$wpdb->postmeta}` 
            SET meta_value = '1' 
            WHERE meta_key = '{$prefix}_postTemplate' AND meta_value = '{$this->id}'");
    }
}
