<?php

ytg_Core::load('Framework_Model_Form_Options');
/**
 * @property $expectedVideoCount
 */
class ytg_Model_Form_Admin extends ytg_Framework_Model_Form_Options
{
    public $searchMode;
    public $keyword;
    public $negativeKeywords;
    public $channels;
    public $sortOrder;
    public $filterDuration;
    public $minViews;
    public $maxCount;
    public $videoIdList;
    public $publicationMethod;
    public $postsPerWeek;
    public $postCategories = array();
    public $postTemplate;
    public $postType;

    public $videoIds;

    public $attributeProperties = array(
        'publicationMethod' => array('help' => FALSE),
        'videoIds' => array('help' => FALSE),
        'postsPerWeek' => array('help' => FALSE),
        'searchMode' => array('help' => FALSE),
        'videoIdList' => array('help' => FALSE),
    );

    public $attributePropertyDefaults = array(
        'help' => TRUE,
    );

    protected $_postTypeList;

    public function rules()
    {
        return array(
            array('searchMode', 'in', 'range' => array_keys($this->getSearchModeList())),
            array('searchMode', 'required'),

            array('keyword', 'filter', 'filter' => 'stripslashes'),
            array('keyword', 'trim'),
            array('keyword', 'filter', 'filter'
                => array('Framework_Helper_Filter', 'stripNewLines')),
            array('keyword', 'match',
                'not' => TRUE,
                'pattern' => '~\-~isu',
                'message' => '{attribute} does not allow minus (-) character',
            ),
            array('keyword', 'match',
                'not' => TRUE,
                'pattern' => '~\|~isu',
                'message' => '{attribute} does not allow pipe (|) character',
            ),
            array('keyword', 'default'),

            array('negativeKeywords', 'filter', 'filter' => 'stripslashes'),
            array('negativeKeywords', 'trim'),
            array('negativeKeywords', 'filter', 'filter'
                => array('Framework_Helper_Filter', 'filterList')),
            array('negativeKeywords', 'match',
                'not' => TRUE,
                'pattern' => '~\-~isu',
                'message' => '{attribute} does not allow minus (-) character',
            ),
            array('negativeKeywords', 'default'),

            array('channels', 'filter', 'filter' => 'stripslashes'),
            array('channels', 'trim'),
            array('channels', 'filter',
                'filter' => array('Framework_Helper_Filter', 'filterList'),
                'params' => array(
                    'itemFilters' => array(
                        array('ytg_Helper_YouTube', 'filterChannel'),
                    )
                ),
            ),
            array('channels', 'default'),

            array('sortOrder', 'in', 'range' => array_keys(
                $this->getSortOrderList())),
            array('sortOrder', 'required'),

            array('filterDuration', 'default'),
            array('filterDuration', 'in', 'range' => array_keys($this->getFilterDurationList())),

            array('minViews', 'trim'),
            array('minViews', 'integer', 'min' => 0),
            array('minViews', 'default'),

            array('maxCount', 'trim'),
            array('maxCount', 'integer', 'min' => 0, 'max' => 1000000),
            array('maxCount', 'required'),

            array('videoIdList', 'filter', 'filter' => 'stripslashes'),
            array('videoIdList', 'trim'),
            array('videoIdList', 'filter',
                'filter' => array('Framework_Helper_Filter', 'filterList'),
                'params' => array(
                    'itemFilters' => array(
                        array('ytg_Helper_YouTube', 'filterVideo'),
                    )
                ),
            ),
            array('videoIdList', 'default'),
            array('videoIdList', 'required',
                'when' => array($this, '_isVideoIdListRequired'),
            ),

            array('publicationMethod', 'in', 'range' => array_keys(
                $this->getPublicationMethodList())),
            array('publicationMethod', 'required'),

            array('postsPerWeek', 'in', 'range' => array_keys(
                $this->getPostsPerWeekList())),
            array('postsPerWeek', 'required',
                'when' => array($this, '_isPostsPerWeekRequired')),

            array('postCategories', 'Validator_PostCategories'),
            array('postCategories', 'default', 'value' => array()),

            array('postTemplate', 'integer'),
            array('postTemplate', 'exist',
                'targetClass' => 'Model_Template',
                'targetAttribute' => 'id',
            ),
            array('postTemplate', 'default'),

            array('videoIds', 'inline',
                'method' => '_validateVideoIds',
                'on' => 'add-selected',
                'except' => 'permanent',
                'skipOnEmpty' => FALSE,
            ),

            array('postType', 'in',
                'range' => ytg_Core::$app->postTypes->getContentTypes(),
            ),
            array('postType', 'required'),
        );
    }

    public function attributeLabels()
    {
        return array(
            'keyword' => 'Keyword',
            'negativeKeywords' => 'Filter out These Keywords',
            'channels' => 'Only Search in These YouTube Channels',
            'sortOrder' => 'Sort Videos by',
            'filterDuration' => 'Video Duration',
            'minViews' => 'Show Videos with at Least {X} Views',
            'maxCount' => 'Fetch {X} Total Videos',
            'publicationMethod' => 'Scheduling Options',
            'postsPerWeek' => 'Schedule {X} Posts per Week',
            'postCategories' => 'Schedule Posts under This Category',
            'postTemplate' => 'Select Post Template',
            'videoIds' => 'Videos',
            'postType' => 'Generate Custom Post Types',
            'videoIdList' => 'YouTube Video IDs',
        );
    }

    //
    // Lists
    //

    public function getSortOrderList()
    {
        return array(
            'viewCount' => 'popularity',
            'rating' => 'rating',
            'date' => 'most recent',
            'relevance' => 'relevance',
        );
    }

    public function getPublicationMethodList()
    {
        return array(
            'schedule' => 'Schedule {X} posts per week ',
            'publish' => 'Publish all posts immediately',
            'draft' => 'Save all posts as drafts',
        );
    }

    public function getPostsPerWeekList()
    {
        return array(
            '1' => '1',
            '7' => '7',
            '15' => '15',
            '30' => '30',
            '100' => '100',
        );
    }

    public function getFilterDurationList()
    {
        return array(
            'long' => 'long',
            'medium' => 'medium',
            'short' => 'short',
        );
    }

    public function getPostTemplateList()
    {
        return ytg_Core::$app->model('Model_Template')->getList();
    }

    public function getPostTypeList()
    {
        return ytg_Core::$app->postTypes->getList();
    }

    public function getSearchModeList()
    {
        return array(
            'keyword' => 'Search by Keyword',
            'ids' => 'Search by Video IDs',
        );
    }

    //
    // Dynamic values
    //

    public function getExpectedVideoCount()
    {
        return is_null($this->videoIds)
            ? $this->maxCount
            : count($this->videoIds);
    }

    public function getVideoIdListArray()
    {
        if ('ids' != $this->searchMode
            || '' == $this->videoIdList
        ) {
            return array();
        }

        return explode("\n", $this->videoIdList);
    }

    //
    // Validation
    //

    protected function _isCategoryExist($id)
    {
        return (bool) get_term_by('id', $id, 'category');
    }

    public function _isPostsPerWeekRequired()
    {
        return 'schedule' == $this->publicationMethod;
    }

    public function _validateVideoIds()
    {
        $value = $this->videoIds;

        if (!$value) {
            $this->addError('videoIds', 'Please select at least one video to generate a post for');
            return;
        }

        if (!is_array($value)) {
            $this->addError('videoIds', 'Parameter "videoIds" should be array');
            return;
        }
    }

    public function _isVideoIdListRequired()
    {
        return 'ids' == $this->searchMode;
    }
}