<?php
ytg_Core::load('Controller_Base_Admin');

class ytg_Controller_Admin extends ytg_Controller_Base_Admin
{
    public function actionIndex()
    {
        if (ytg_Core::$app->process->isActive) {
            return $this->_displayProgress();
        }

        /**
         * @var $model ytg_Model_Form_Admin
         */
        $model = ytg_Core::create('Model_Form_Admin');

        $preview = NULL;

        $errors = array();
        if (!ytg_Core::$app->client_Youtube->hasCredentials) {
            // Redirect since 0.2:
            ytg_Core::$app->view->messages()->add('To start using the plugin please enter your Google YouTube API key.', 'info');
            return $this->redirect(array(
                'pluginPage' => 'admin-options',
            ));
            //$errors['youtube-credentials'] = TRUE;
        }

        if ($_POST && !isset($errors['youtube-credentials'])) {
            $this->_localizeGlobalParameter('post_category', $model->formName(),
                'postCategories');

            $action = isset($_POST['action'])? $_POST['action'] : 'generate';
            $model->scenario = $action == 'add-selected'
                ? 'add-selected'
                : 'default';

            $model->load($_POST);

            if ($model->save()) {
                if ('preview' != $action) { // generate or add-selected
                    // Check quota
                    $allowTextSpinningOff = isset($_POST['allowTextSpinningOff'])
                        && $_POST['allowTextSpinningOff'];
                    if (!$allowTextSpinningOff
                        || 'pro' != ytg_Core::config('edition')
                    ) {
                        try {
                            $quota = ytg_Core::$app->client_Spinrewriter->getQuota();
                            if ($quota < $model->expectedVideoCount) {
                                $errors['spinrewriter-quota'] = compact('quota');
                            }
                        } catch (ytg_Component_Client_Spinrewriter_QuotaException $e) {
                            $errors['spinrewriter-quota'] = TRUE;
                        } catch (ytg_Component_Client_Spinrewriter_Exception $e) {
                            // Ignore this error for now
                        }
                    }

                    if (!$errors) {
                        $startParams = compact('allowTextSpinningOff');
                        if ('add-selected' == $action) {
                            $startParams['videoIds'] = $model->videoIds;
                        } else if ('ids' == $model->searchMode) {
                            $startParams['videoIds'] = $model->getVideoIdListArray();
                        }

                        return $this->_displayProgress($model, $startParams);
                    }
                } else { //preview

                    /**
                     * @var ytg_Component_Generator $generator
                     */
                    $generator = ytg_Core::$app->generator;

                    if ('ids' == $model->searchMode) {
                        $generator->videoIds = $model->getVideoIdListArray();
                    }

                    try {
                        $preview = $generator->preview();
                        ytg_Core::$app->cache->set('preview', $preview);

                        if (!$preview) {
                            ytg_Core::$app->view->messages()->add('No results found', 'warning');
                        }
                    } catch (ytg_Component_Generator_Exception $e) {
                        $prev = $e->getPrevious();
                        if ($prev instanceof ytg_Component_Client_Youtube_Exception
                            && 'invalidChannelId' == $prev->reason
                        ) {
                            $errors['invalid-channel-id'] = array(
                                'e' => $prev,
                            );
                        } else{
                            ytg_Core::$app->view->messages()->add($e->getMessage(), 'error');
                        }
                    }
                }
            } else {
                // Invalid
                $this->_displayFormErrors($model);

                if ('add-selected' == $action) {
                    $preview = ytg_Core::$app->cache->get('preview');
                    if (!$preview) {
                        ytg_Core::$app->view->message('Preview session expired', 'error');
                    }
                }
            }
        } else {
            $model->refresh();
        }

        $this->layoutParams['announcement'] =
            ytg_Core::create('Model_AnnouncementHtml')->get();

        return $this->render('admin/index', compact('model', 'errors', 'preview'));
    }

    public function actionOptions()
    {
        /**
         * @var $model ytg_Model_Form_Options
         */
        $model = ytg_Core::create('Model_Form_Options');

        if ($_POST) {
            if (isset($_POST['action'])
                && 'refresh-onlywire-services' == $_POST['action']
            ) {
                $model->refresh();
                $model->scenario = 'refresh-onlywire-services';
            }

            $model->load($_POST);

            if ($model->save()) {
                if ('default' == $model->scenario) {
                    ytg_Core::$app->view->messages()->add("Settings saved.");
                } else if ('refresh-onlywire-services' == $model->scenario
                    && $model->onlywireServiceList
                ) {
                    ytg_Core::$app->view->messages()->add("Onlywire profiles refreshed.");
                }
            } else {
                $this->_displayFormErrors($model);
            }
        } else {
            $model->refresh();
            $model->loadOnlywireServices();
        }

        foreach ($model->errors as $error) {
            ytg_Core::$app->view->messages()->add($error, 'error');
        }

        return $this->render('admin/options', compact('model'));
    }

    public function actionAddCategory($name, $parentId)
    {
        try {
            $name = trim($name);

            if ('' == $name) {
                throw new ytg_Controller_Admin_Exception('Category name is required');
            }

            $result = wp_insert_category(
                array(
                    'cat_name' => $name,
                    'category_parent' => $parentId,
                ),
                TRUE
            );

            if (is_wp_error($result)) {
                throw new ytg_Controller_Admin_Exception($result->get_error_message());
            }

            $result = get_category($result, ARRAY_A);
            if (is_wp_error($result)) {
                throw new ytg_Controller_Admin_Exception($result->get_error_message());
            }
            if (!$result) {
                throw new ytg_Controller_Admin_Exception('Cannot access category created');
            }
        } catch (ytg_Controller_Admin_Exception $e) {
            return array(
                'status' => 'error',
                'errorMessage' => $e->getMessage(),
            );
        }

        return array(
            'status' => 'success',
            'category' => $result,
            'categoryList' => $this->render('admin/index/post-categories-checklist', array(
                'value' => array($result['term_id']),
            )),
            'parentCategoryDropdown'
                => $this->render('admin/index/parent-category-dropdown'),
        );
    }

    public function actionTerminate()
    {
        ytg_Core::$app->process->terminate();

        return $this->redirect();
    }

    protected function _displayProgress($model = NULL, $params = NULL)
    {
        return $this->render('admin/progress', compact('model', 'params'));
    }

    public function actionStartProcess($sessionId, $params)
    {
        ini_set('error_reporting', E_ALL);
        ini_set('html_errors', 0);
        ini_set('display_errors', 1);

        if (session_id()) {
            session_write_close();
        }
        session_id($sessionId);
        session_start();

        $params['allowTextSpinningOff'] = isset($params['allowTextSpinningOff'])
            && 'true' == $params['allowTextSpinningOff'];

        /**
         * @var ytg_Component_Generator $worker
         */
        $worker = ytg_Core::$app->generator;
        $worker->configure($params);

        ytg_Core::$app->process->run($worker);
    }

    public function actionUpdateProgress()
    {
        if (isset($_POST['sessionId'])) {
            if (session_id()) {
                session_write_close();
            }
            session_id($_POST['sessionId']);
        }
        session_start();

        /**
         * @var $process ytg_Component_Process
         */
        $process = ytg_Core::$app->process;

        $output = $process->getOutput(
            isset($_POST['logOffset'])? $_POST['logOffset'] : 0);

        $result = array();

        $result['log'] = array(
            'content' => $this->_formatLog($output['log']),
            'offset' => $output['logOffset'],
        );

        if (isset($output['logTruncated']) && $output['logTruncated']) {
            $result['log']['content'] = "<em>(long output truncated)</em><br>\n<br>\n"
                . $result['log']['content'];
        }

        $status = isset($output['status'])? $output['status'] : NULL;

        if (!is_null($status)) {
            $result['status'] = array(
                'name' => $status,
                'content' => isset($output['statusText'])
                    ? ytg_Core::$app->view->escape($output['statusText'])
                    : ''
            );
        }

        switch ($status) {
            case 'progress':
                break;

            case 'error': //no break
            case 'success':
                $result['terminate'] = true;
                $process->clearOutput();
                break;

            default:
                //$result['log'] = ("SESSION: " . session_id() . "\n");
        }

        return $result;
    }

    public function actionUpdateScreenSetting($name, $value)
    {
        ytg_Core::$app->options->set("screen_{$name}", $value);

        return array(
            'status' => 'success',
        );
    }

    protected function _formatLog($text)
    {
        return nl2br(ytg_Core::$app->view->escape($text));
    }
}

class ytg_Controller_Admin_Exception extends Exception
{

}