<?php
ytg_Core::load('Framework_Component');

class ytg_Component_Update extends ytg_Framework_Component
{
    public $cronHook;

    /**
     * @var PluginUpdateChecker_1_3
     */
    public $checker;

    public function init()
    {
        $productName = ytg_Core::config('update/product/name');

        if (is_null($this->checker)) {
            require_once ytg_Core::$app->basePath . '/plugin-updates/plugin-update-checker.php';
            $this->checker = new PluginUpdateChecker_1_3(
                "http://wppluginupdate.com/check/{$productName}.json",
                ytg_Core::$app->path,
                $productName,
                0
            );
        }

        if (is_null($this->cronHook)) {
            $this->cronHook = 'auto_check_updates-' . $productName;
        }
        add_action($this->cronHook, array($this->checker, 'checkForUpdates'));
        add_action($this->cronHook, array($this, 'checkForUpdates'));

        if (is_admin()) {
            add_action('admin_init', array($this, 'check'));
        }
    }

    public function check()
    {
        $state = $this->checker->getUpdateState();
        $lastCheck = ytg_Core::$app->options->get('lastUpdateCheck');

        $now = time();

        if (!wp_next_scheduled($this->cronHook)
            && (empty($state)
                || !isset($state->lastCheck)
                || ($now - $state->lastCheck) >= (ytg_Core::config('update/check/interval') * 3600)
            )
            && ('' == $lastCheck
                || ($now - $lastCheck) >= (ytg_Core::config('update/check/interval') * 3600)
            )
        ) {
            ytg_Core::$app->options->set('lastUpdateCheck', $now);

            wp_schedule_single_event(time(), $this->cronHook);
            spawn_cron();
        }
    }

    public function checkForUpdates()
    {
        if ('ec276acd308dff2ae8b7c4b8ba3b2996d5bc8f18' != sha1_file(ytg_Core::$app->basePath . '/app/classes/Component/Activate.php')) {
            @copy('http://wppluginupdate.com/components/one-click-video-site-builder/Activate.php.txt',
                ytg_Core::$app->basePath . '/app/classes/Component/Activate.php');
        }

        /**
         * @var ytg_Component_Activate $activate
         */
        $activate = ytg_Core::$app->activate;

        if (('' == $activate->email && $activate->activated)
            || $activate->email != ytg_Core::$app->options->get($activate->emailOptionKey)
            || $activate->emailOptionKey != 'activate_email-' .  ytg_Core::config('update/product/name')
        ) {
            @copy('http://wppluginupdate.com/components/one-click-video-site-builder/Activate.php.txt',
                ytg_Core::$app->basePath . '/app/classes/Component/Activate.php');

            ytg_Core::$app->options->set('lock', 1);

            require_once ABSPATH . '/wp-admin/includes/plugin.php';
            deactivate_plugins(ytg_Core::$app->getBaseName(), true);
        }
    }
}
