<?php
ytg_Core::load('Framework_Component');

class ytg_Component_Helper extends ytg_Framework_Component
{
    public function init()
    {
        add_action('delete_category', array($this, 'onCategoryDelete'));

        add_action('save_post', array($this, 'sharePost'), 10, 1);
        add_action('publish_post', array($this, 'sharePost'), 10, 1);
    }

    public function onCategoryDelete($id)
    {
        ytg_Core::$app->model('Model_Channel')->onCategoryDelete($id);
    }

    public function sharePost($postId)
    {
        if ('publish' == get_post_status($postId)) {
            /**
             * @var ytg_Framework_Component_Meta $meta
             */
            $meta = ytg_Core::create('Framework_Component_Meta', array(
                'id' => $postId,
            ));

            $services = $meta->get('onlywireServices');
            if ($services) {
                try {
                    ytg_Core::$app->generator->sharePost(get_post($postId),
                        $services);
                } catch (ytg_Component_Client_Onlywire_Exception $e) {
                    return;
                }

                $meta->delete('onlywireServices');
            }
        }
    }
}