<?php
ytg_Core::load('Framework_Component');

class ytg_Component_Frontend extends ytg_Framework_Component
{
    public function init()
    {
        if (!is_admin()) {
            $this->_enableFilters();

            add_action(
                'srpw_before_loop',
                [$this, '_disableFilters']
            );

            add_action(
                'srpw_after_loop',
                [$this, '_enableFilters']
            );
        }
    }

    public function _enableFilters()
    {
        add_filter(
            'post_thumbnail_html',
            [$this, '_filterFeaturedImage'],
            10,
            2
        );

        add_filter(
            'has_post_thumbnail',
            [$this, '_filterHasFeaturedImage'],
            10,
            2
        );
    }

    public function _disableFilters()
    {
        remove_filter(
            'post_thumbnail_html',
            [$this, '_filterFeaturedImage']
        );

        remove_filter(
            'has_post_thumbnail',
            [$this, '_filterHasFeaturedImage']
        );
    }

    protected function isFeaturedImageSuppressed($postId)
    {
        global $post;

        return ytg_Core::$app->options->get('displaySuppressFeaturedImage')
            && is_singular('post')
            && !empty(get_post_meta($postId, 'ytg_videoId'))
            && $postId == $post->ID;
    }

    /**
     * Suppress featured image for a generated post if enabled
     *
     * @param string $result
     * @param int $postId
     * @return string
     */
    public function _filterFeaturedImage($result, $postId)
    {
        if (!$this->isFeaturedImageSuppressed($postId)) {
            return $result;
        }

        return '';
    }

    public function _filterHasFeaturedImage($result, $post)
    {
        if (!is_a($post, 'WP_Post')) {
            $post = get_post($post);
        }

        if (!$post || !$this->isFeaturedImageSuppressed($post->ID)) {
            return $result;
        }

        return false;
    }
}