<?php
ytg_Core::load('Framework_Component');

class ytg_Component_ErrorHandler extends ytg_Framework_Component
{
    /**
     * Encapsulates set_error_handler()
     */
    public function enable($errorTypes=E_ALL)
    {
        set_error_handler(array(get_class(), 'handleError'), $errorTypes);
    }

    /**
     * Encapsulates restore_error_handler()
     */
    public function disable()
    {
        restore_error_handler();
    }

    /**
     * Handles PHP Errors
     */
    public function handleError($errno, $errstr, $errfile, $errline,
        $errcontext)
    {
        if (0 == error_reporting()) {
            // @ operator
            return FALSE;
        }

        header('HTTP/1.1 500 Internal Server Error', TRUE, 500);

        throw new ErrorException($errstr, 0, $errno, $errfile, $errline);
    }
}
