<?php
ytg_Core::load('Framework_Component');
ytg_Core::load('Framework_Helper_Filter');
ytg_Core::load('Framework_Helper_Http');

class ytg_Component_Client_Cpanel extends ytg_Framework_Model
{
    public $username;
    public $password;

    public $baseUrl = 'https://127.0.0.1:2083/json-api/cpanel';

    public $commonParams = array(
        'cpanel_jsonapi_apiversion' => 2,
    );

    function call($module, $function, $params=array())
    {
        $params = array_merge($this->commonParams, $params);

        $params['cpanel_jsonapi_module'] = $module;
        $params['cpanel_jsonapi_func'] = $function;

        $url = $this->baseUrl . '?' . http_build_query($params, '', '&');

        $curl =  ytg_Framework_Helper_Http::initCurl($url, array(
            CURLOPT_HTTPHEADER => array('Authorization: Basic '
                . base64_encode($this->username . ":" . $this->password) . "\n\r"),
        ));

        $result = curl_exec($curl);
        if (FALSE === $result) {
            $error = curl_error($curl);
            curl_close($curl);
            throw new ytg_Component_Client_Cpanel_Exception($error);
        }

        $result = json_decode($result, TRUE);
        if (!$result) {
            throw new ytg_Component_Client_Cpanel_Exception(
                'Invalid cPanel API response: Could not decode JSON.');
        }

        if (isset($result['cpanelresult']['error'])) {
            throw new ytg_Component_Client_Cpanel_Exception($result['cpanelresult']['error']);
        }

        $code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        if (200 != $code) {
            curl_close($curl);
            throw new ytg_Component_Client_Cpanel_Exception("HTTP error #{$code}");
        }

        return $result;
    }

    public function addCronJob(array $job)
    {
        $response = $this->call('Cron', 'listcron');

        if (!isset($response['cpanelresult']['data'])) {
            throw new ytg_Component_Client_Cpanel_Exception("Invalid response, data not found");
        }

        foreach ($response['cpanelresult']['data'] as $listJob) {
            if (!array_diff($job, $listJob)) {
                throw new ytg_Component_Client_Cpanel_DuplicateException('The cron job already exists');
            }
        }

        $this->call('Cron', 'add_line', $job);
    }

    public function rules()
    {
        return array(
            array('username', 'filter', 'filter' => 'stripslashes'),
            array('username', 'trim'),
            array('username', 'filter',
                'filter' => array('ytg_Framework_Helper_Filter', 'stripNewLines')),
            array('username', 'required'),

            array('password', 'filter', 'filter' => 'stripslashes'),
            array('password', 'trim'),
            array('password', 'filter',
                'filter' => array('ytg_Framework_Helper_Filter', 'stripNewLines')),
            array('password', 'required'),
        );
    }

    public function attributeLabels()
    {
        return array(
            'username' => 'cPanel Username',
            'password' => 'cPanel Password',
        );
    }
}

class ytg_Component_Client_Cpanel_Exception extends Exception
{

}

class ytg_Component_Client_Cpanel_DuplicateException
    extends ytg_Component_Client_Cpanel_Exception
{

}