<?php
ytg_Core::load('Framework_Component');

class ytg_Component_Assets extends ytg_Framework_Component
{
    public function init()
    {
        if (is_admin()) {
            add_action('admin_enqueue_scripts', array($this, 'registerAdmin'));
            add_filter('mce_css', array($this, '_editorCss'));
        } else {
            add_action('wp_enqueue_scripts', array($this, 'registerFront'));
        }
    }

    public function registerAdmin($hook)
    {
        $baseUrl = ytg_Core::$app->baseUrl;
        $slug = ytg_Core::$app->slug;

        switch ($hook) {
            case 'post.php':
            case 'post-new.php':
                $this->registerCategoryChecklist();

                break;

            default:
                if (FALSE === strpos($hook, "_page_{$slug}-")) {
                    // Do not include common stuff for other pages
                    return;
                }
        }

        // Common stuff goes here:
        wp_enqueue_style(ytg_Core::$app->slug . '-admin',
            "{$baseUrl}assets/css/admin.css",
            array(),
            ytg_Core::$app->version);
        wp_enqueue_script(ytg_Core::$app->slug . '-admin',
            "{$baseUrl}assets/js/admin.js",
            array('jquery'),
            ytg_Core::$app->version);

        // Help assets:
        wp_enqueue_script(ytg_Core::$app->slug . '-help',
            "{$baseUrl}assets/js/help.js",
            array('jquery'),
            ytg_Core::$app->version);
        wp_enqueue_style(ytg_Core::$app->slug . '-help',
            "{$baseUrl}assets/css/help.css",
            array(),
            ytg_Core::$app->version);
    }

    public function registerFront()
    {
        if (!ytg_Core::$app->activate->activated
            || '' == ytg_Core::$app->activate->email
        ) {
            return $this;
        }

        $app = ytg_Core::$app;

        wp_enqueue_style(ytg_Core::$app->slug . '-front',
            "{$app->baseUrl}assets/css/front.css",
            array(),
            ytg_Core::$app->version);
        wp_enqueue_script(ytg_Core::$app->slug . '-front',
            "{$app->baseUrl}assets/js/front.js",
            array('jquery'),
            ytg_Core::$app->version);

        return $this;
    }

    public function registerCategoryChecklist()
    {
        wp_enqueue_script('jquery-scrollTo',
            ytg_Core::$app->baseUrl . 'assets/vendor/jquery.scrollTo/jquery.scrollTo.'
            . (SCRIPT_DEBUG? 'js' : 'min.js'),
            array('jquery'),
            '2.1.2');

        $this->registerResizable();

        return $this;
    }

    public function registerTemplatePreview()
    {
        $this->registerResizable();

        return $this;
    }

    public function registerResizable()
    {
        wp_enqueue_script('jquery-ui-resizable');
        wp_enqueue_style('wp-jquery-ui-dialog');

        return $this;
    }

    public function _editorCss($css)
    {
        if ('' != $css) {
            $css .= ',';
        }

        $css .= ytg_Core::$app->baseUrl . 'assets/css/editor.css';

        return $css;
    }
}