<?php
ytg_Core::load('Framework_Component');

class ytg_Component_Admin extends ytg_Framework_Component
{
    protected $_contentCache;

    protected $_postTypeList;

    public function init()
    {
        if (!session_id()) {
            session_start();
        }

        $activate = ytg_Core::$app->activate;
        if (!$activate->activated || '' == $activate->email
            || $activate->email != ytg_Core::$app->options->get($activate->emailOptionKey)
        ) {
            return;
        }

        add_action('admin_menu', array($this, 'registerMenu'));
        add_action('admin_init', array($this, 'detectPageRequest'));

        if ('pro' == ytg_Core::config('edition')) {
            add_action('add_meta_boxes', array($this, 'registerMetaBoxes'));
            add_action('save_post', array(ytg_Core::$app, 'dispatch_metabox_save'));
        }
    }

    public function registerMenu()
    {
        if (get_option('ytg_lock')) {
            return;
        }

        $positionCount = 0;
        foreach (ytg_Core::$app->loadConfig('admin-menu') as $key => $config) {
            $slug = ytg_Core::$app->slug . '-' . $key;

            if (isset($config['position'])) {
                $position = $config['position'];
            } else {
                $position = ytg_Core::config('admin/menu/defaultPosition');
                if (!is_null($position)) {
                    $position .= '.' . str_pad($positionCount, 3, '0',
                            STR_PAD_LEFT);

                    $positionCount++;
                }
            }

            $capability = isset($config['capability'])
                ? $config['capability']
                : ytg_Core::config('requirement/wordpress/user/capability');

            $iconUrl = NULL;
            if (isset($config['iconFile'])) {
                $iconUrl = ytg_Core::$app->baseUrl . 'assets/images/' . $config['iconFile'];
            }

            add_menu_page(
                // page title
                $config['title'],
                // menu title
                isset($config['menuTitle'])? $config['menuTitle'] : $config['title'],
                // capability
                $capability,
                // slug
                $slug,
                // callback
                array($this, 'dispatch'),
                // icon
                $iconUrl,
                // position
                $position
            );

            if (isset($config['children'])) {
                foreach ($config['children'] as $childKey => $child) {
                    $childSlug = '' == $childKey
                        ? $slug
                        : ytg_Core::$app->slug . '-' . $childKey;

                    add_submenu_page(
                        // parent slug
                        $slug,
                        // page title
                        $child['title'],
                        // menu title
                        isset($child['menuTitle'])?
                            $child['menuTitle']
                            : $child['title'],
                        // capability
                        isset($child['capability'])
                            ? $child['capability']
                            : $capability,
                        // slug
                        $childSlug,
                        // callback
                        array($this, 'dispatch')
                    );
                }
            }
        }
    }

    public function detectPageRequest()
    {
        if (ytg_Core::isAjaxRequest()) {
            return;
        }

        if (!isset($_GET['page'])) {
            return;
        }

        $parts = $this->_parsePageName($_GET['page']);
        if (!$parts) {
            return;
        }

        // Process page request
        $params = $_GET;
        unset($params['page']);
        $params['_return'] = TRUE;

        $this->_contentCache = ytg_Core::$app->dispatch($parts['controller'],
                $parts['action'], $params);
    }

    public function dispatch()
    {
        if (!is_null($this->_contentCache)) {
            echo $this->_contentCache;
        } else {
            throw new Exception('Request was not processed');
        }
    }

    protected function _parsePageName($name)
    {
        $slug = ytg_Core::$app->slug;
        if (substr($name, 0, strlen($slug) + 1) !=  $slug . '-') {
            return NULL;
        }

        $name = substr($name, strlen($slug) + 1);

        $parts = explode('-', $name);
        if (!$parts) {
            return NULL;
        }

        return array(
            'controller' => $parts[0],
            'action' => isset($parts[1])? $parts[1] : NULL,
        );
    }

    public function registerMetaBoxes()
    {
        foreach (ytg_Core::$app->loadConfig('metaboxes') as $key => $config) {
            add_meta_box(ytg_Core::$app->prefix . '_' . $key,
                $config['title'],
                array(ytg_Core::$app, "dispatch_metabox_{$key}"),
                isset($config['screen'])? $config['screen'] : NULL,
                isset($config['context'])? $config['context'] : 'advanced',
                isset($config['priority'])? $config['priority'] : 'default'
            );
        }
    }
}
