<?php
ytg_Core::load('Framework_Model');
ytg_Core::load('Framework_Helper_Filter');
ytg_Core::load('Framework_Helper_Http');

/**
 * Class ytg_Component_Activate
 * @property string $productName
 * @property string $email
 * @property string $emailOptionKey
 * @property boolean $activated
 */
class ytg_Component_Activate extends ytg_Framework_Model
{
    protected $_productName;
    protected $_emailOptionKey;
    protected $_email;
    protected $_activated;

    public function init()
    {
        $this->_productName = ytg_Core::config('activate/product/name');
        if (is_null($this->_productName)) {
            $this->_productName = ytg_Core::config('update/product/name');
        }
        $this->_emailOptionKey = "activate_email-{$this->_productName}";

        $this->_email = ytg_Core::$app->options->get($this->_emailOptionKey);
        $this->_activated = !is_null($this->_email);

        if (ytg_Core::$app->options->get('lock')
            || !$this->_activated
            || '' == $this->_email
        ) {
            ytg_Core::$app->setRegistryValue('abort', TRUE);
        }

        add_action('init', array($this, '_onInit'));
    }

    public function rules()
    {
        return array(
            array('email', 'filter',
                'filter' => array('ytg_Framework_Helper_Filter', 'stripNewLines')),
            array('email', 'trim'),
            array('email', 'required'),
        );
    }

    public function attributeLabels()
    {
        return array(
            'email' => 'PayPal E-Mail',
        );
    }

    public function _registerMenu()
    {
        $title = ytg_Core::config('plugin/title');

        add_menu_page($title,
            ytg_Core::config('plugin/title/short', $title),
            ytg_Core::config('requirement/wordpress/user/capability'),
            ytg_Core::$app->slug . '-admin',
            array(ytg_Core::$app, 'dispatch_activate'),
            ytg_Core::$app->baseUrl . 'assets/images/menu-icon.png'
        );

        add_submenu_page(ytg_Core::$app->slug . '-admin',
            'Activate',
            'Activate',
            ytg_Core::config('requirement/wordpress/user/capability'),
            ytg_Core::$app->slug . '-admin',
            array(ytg_Core::$app, 'dispatch_activate')
        );
    }

    //
    // Activation methods
    //

    public function activate()
    {
        $result = $this->inquiry('activation');

        if ($result) {
            ytg_Core::$app->options->set($this->_emailOptionKey, $this->_email);

            $this->_activated = TRUE;
        }

        return $result;
    }

    public function deactivate()
    {
        ytg_Core::$app->options->delete($this->_emailOptionKey);
        $this->_email = NULL;

        return $this;
    }

    public function inquiry($type='verification')
    {
        $params = array(
            'client_email' => $this->_email,
            'product_name' => $this->_productName,
            'site_url' => site_url(),
            'type' => $type,
        );

        return $this->_request($params);
    }

    protected function _request(array $params)
    {
        $url = ytg_Core::config('activate/api/url');

        $curl = ytg_Framework_Helper_Http::initCurl($url, array(
            CURLOPT_POST => TRUE,
            CURLOPT_POSTFIELDS => http_build_query($params, '', '&'),
            CURLOPT_FAILONERROR => TRUE,
        ));

        // execute post
        $result = curl_exec($curl);
        if (FALSE === $result) {
            $error = curl_error($curl);
            curl_close($curl);
            throw new ytg_Component_Activate_Exception($error);
        }

        curl_close($curl);

        $result = json_decode($result, TRUE);
        if (!$result || !isset($result['valid'])) {
            throw new ytg_Component_Activate_Exception('Cannot decode response.');
        }

        return $result['valid'];
    }

    //
    // Getters & setters
    //

    /**
     * @return boolean
     */
    public function getActivated()
    {
        return $this->_activated;
    }

    /**
     * @return string
     */
    public function getProductName()
    {
        return $this->_productName;
    }

    /**
     * @return string
     */
    public function getEmailOptionKey()
    {
        return $this->_emailOptionKey;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->_email;
    }

    protected function setEmail($value)
    {
        $this->_email = $value;

        return $this;
    }

    //
    // Event Handlers
    //

    public function _onInit()
    {
        if (!$this->_activated || '' == $this->_email
            || $this->_email != ytg_Core::$app->options->get($this->_emailOptionKey)
        ) {
            $this->_activated = FALSE;
            add_action('admin_menu', array($this, '_registerMenu'));
        }
    }
}

class ytg_Component_Activate_Exception extends Exception
{

}