<?php
/**
 * @link http://www.yiiframework.com/
 * @copyright Copyright (c) 2008 Yii Software LLC
 * @license http://www.yiiframework.com/license/
 */

ytg_Core::load('Framework_Validator');

class ytg_Framework_Validator_Array extends ytg_Framework_Validator
{
    public $max;

    public $min;
    /**
     * @var string user-defined error message used when the value is bigger than [[max]].
     */
    public $tooBig;
    /**
     * @var string user-defined error message used when the value is smaller than [[min]].
     */
    public $tooSmall;

    /**
     * @inheritdoc
     */
    public function init()
    {
        parent::init();
        if ($this->message === null) {
            $this->message = '{attribute} must be an array.';
        }
        if ($this->min !== null && $this->tooSmall === null) {
            $this->tooSmall = '{attribute} must have no less than {min} items.';
        }
        if ($this->max !== null && $this->tooBig === null) {
            $this->tooBig = '{attribute} must have no greater than {max} items.';
        }
    }

    /**
     * @inheritdoc
     */
    public function validateAttribute($model, $attribute)
    {
        $value = $model->$attribute;
        if (!is_array($value)) {
            $this->addError($model, $attribute, $this->message);
        } else {
            if ($this->min !== null && count($value) < $this->min) {
                $this->addError($model, $attribute, $this->tooSmall, array('min' => $this->min));
            }
            if ($this->max !== null && count($value) > $this->max) {
                $this->addError($model, $attribute, $this->tooBig, array('max' => $this->max));
            }
        }
    }

    /**
     * @inheritdoc
     */
    protected function validateValue($value)
    {
        if (!is_array($value)) {
            return array('{attribute} must be an array.', array());
        } elseif ($this->min !== null && count($value) < $this->min) {
            return array($this->tooSmall, array('min' => $this->min));
        } elseif ($this->max !== null && count($value) > $this->max) {
            return array($this->tooBig, array('max' => $this->max));
        } else {
            return null;
        }
    }
}
