<?php
ytg_Core::load('Framework_Controller');

abstract class ytg_Framework_Controller_Web
    extends ytg_Framework_Controller
{
    public function dispatch($controllerName, $actionName=NULL, array $params=array())
    {
        if (!ytg_Core::isAjaxRequest()) {
            if (is_null($actionName) && isset($params['action'])) {
                $actionName = $params['action'];
                unset($params['action']);
            }

            if ('' == $actionName) {
                $actionName = $this->_defaultAction;
            }

            $result = parent::dispatch($controllerName, $actionName, $params);

            if (isset($params['_return']) && $params['_return']) {
                return $result;
            }

            echo $result;

        } else {
            // AJAX

            $result = parent::dispatch($controllerName, $actionName, $params);

            if (is_array($result)) {
                header('Content-Type: application/json');
                $result = json_encode($result);
            }

            echo $result;

            wp_die();
        }
    }
}