<?php
ytg_Core::load('Framework_Component_View_Helper');

class ytg_Framework_Component_View_Helper_WysiwygEditor
    extends ytg_Framework_Component_View_Helper
{
    protected $_contentFilters = array(
        'wp_richedit_pre',
        'wp_htmledit_pre',
    );

    protected $_options;

    public function __invoke($content, $id, array $options)
    {
        if (!isset($options['tinymce'])) {
            $options['tinymce'] = array();
        }

        // buttons
        if (isset($options['toolbars'])) {
            $toolbars = $options['toolbars'];
            unset ($options['toolbars']);

            for ($i=1; $i<=4; $i++) {
                $optionName = 'toolbar' . $i;
                $options['tinymce'][$optionName] = isset($toolbars[$i])
                    ? implode(',', $toolbars[$i])
                    : '';

                // 3.x name
                $options['tinymce']['theme_advanced_buttons' . $i] =
                    $options['tinymce'][$optionName];
            }
        }

        // fonts
        if (isset($options['fonts'])) {
            $fonts = $options['fonts'];
            unset ($options['fonts']);

            $list = array();
            foreach ($fonts as $key=>$value) {
                if (is_array($value)) {
                    $value = implode(',', $value);
                }
                $key = str_replace('_', ' ', $key);
                $list[] = "{$key}={$value}";
            }
            $list = implode(';', $list);

            $options['tinymce']['font_formats'] = $list;
            // 3.x name:
            $options['tinymce']['theme_advanced_fonts'] = $list;
        }

        // unhide_kitchensink
        if (isset($options['unhide_kitchensink'])
            && $options['unhide_kitchensink']
        ) {
            unset($options['unhide_kitchensink']);
            $options['tinymce']['wordpress_adv_hidden'] = FALSE;
        }

        // Disable wpautop call through filters
        $fixWpautop = isset($options['wpautop']) && !$options['wpautop'];
        if ($fixWpautop) {
            $this->_addWpautopFix();
        }

        // Force default editor
        if (isset($options['default_editor'])) {
            add_filter('wp_default_editor', array($this, '_defaultEditor'));
        }

        // For access from filters
        $this->_options = $options;

        //
        // Editor call
        //

        wp_editor($content, $id, $options);
        //ytg_WP_Editors::editor($content, $id, $options);

        // Cleanup
        if ($fixWpautop) {
            $this->_removeWpautopFix();
        }
        if (isset($options['default_editor'])) {
            remove_filter('wp_default_editor', array($this, '_defaultEditor'));
        }

        $this->_options = NULL;
    }

    public function _handleWpautopFix($value)
    {
        foreach ($this->_contentFilters as $filter) {
            if (has_filter('the_editor_content', $filter)) {
                remove_filter('the_editor_content', $filter);
                add_filter('the_editor_content', array($this, '_' . $filter));
            }
        }

        return $value;
    }

    protected function _addWpautopFix()
    {
        add_filter('the_editor', array($this, '_handleWpautopFix'));
    }

    protected function _removeWpautopFix()
    {
        remove_filter('the_editor', array($this, '_handleWpautopFix'));

        foreach ($this->_contentFilters as $filter) {
            remove_filter('the_editor_content', array($this, '_' . $filter));
        }
    }

    public function _wp_richedit_pre($output)
    {
        if (!empty($output)) {
            $output = convert_chars($output);
        }
        // Removed due to breaking JS code
        //$output = htmlspecialchars($output, ENT_NOQUOTES);

        return apply_filters('richedit_pre', $output);
    }

    public function _wp_htmledit_pre($output)
    {
        return apply_filters('htmledit_pre', $output);
    }

    public function _defaultEditor()
    {
        return $this->_options['default_editor'];
    }
}