<?php
ytg_Core::load('Framework_Component_View_Helper');

class ytg_Framework_Component_View_Helper_Messages
    extends ytg_Framework_Component_View_Helper
{
    public $sessionKey;

    public function init()
    {
        if (is_null($this->sessionKey)) {
            $this->sessionKey = ytg_Core::$app->prefix . '_messages';
        }

        if (!isset($_SESSION[$this->sessionKey])
            || !is_array($_SESSION[$this->sessionKey])
        ) {
            $_SESSION[$this->sessionKey] = array();
        }
    }

    public function __invoke($types=NULL)
    {
        return $this->get();
    }

    public function add($message, $status='success', $options=array())
    {
        if (is_array($message)) {
            $options = $message;
        } else {
            $options['text'] = $message;
            $options['status'] = $status;
        }

        $_SESSION[$this->sessionKey][] = $options;

        return $this;
    }

    public function addList(array $messages, $status='success',
        $options=array())
    {
        foreach ($messages as $message) {
            $this->add($message, $status, $options);
        }

        return $this;
    }

    public function set(array $messages)
    {
        $_SESSION[$this->sessionKey] = $messages;

        return $this;
    }

    public function clear()
    {
        $_SESSION[$this->sessionKey] = array();

        return $this;
    }

    public function has($statuses=NULL)
    {
        if (is_null($statuses)) {
            return (bool) $_SESSION[$this->sessionKey];
        }

        $statuses = (array) $statuses;

        foreach ($_SESSION[$this->sessionKey] as $message) {
            if (in_array($message['status'], $statuses)) {
                return TRUE;
            }
        }

        return FALSE;
    }

    public function get($statuses=NULL)
    {
        if (is_null($statuses)) {
            return $_SESSION[$this->sessionKey];
        }

        $statuses = (array) $statuses;

        $result = array();
        foreach ($_SESSION[$this->sessionKey] as $message) {
            if (in_array($message['status'], $statuses)) {
                $result[] = $message;
            }
        }

        return $result;
    }
}