<?php
ytg_Core::load('Framework_Component_View_Helper');

class ytg_Framework_Component_View_Helper_AdminUrl
    extends ytg_Framework_Component_View_Helper
{
    public function __invoke(array $params)
    {
        if (isset($params['pluginPage'])) {
            $params['page'] = ytg_Core::$app->slug . '-' . $params['pluginPage'];
            unset($params['pluginPage']);
        } else if (!isset($params['page'])) {
            $params['page'] = $_GET['page'];
        }

        $priorityOrder = array('page', 'controller', 'action', 'id');
        $resultParams = array();
        foreach ($priorityOrder as $param) {
            if (isset($params[$param])) {
                $resultParams[$param] = $params[$param];
                unset($params[$param]);
            }
        }

        $resultParams = array_merge($resultParams, $params);

        return admin_url('admin.php?')
            . http_build_query($resultParams, '_', '&');
    }
}