<?php
ytg_Core::load('Framework_Component');

abstract class ytg_Framework_Component_OptionsAbstract
    extends ytg_Framework_Component
{
    public $prefix;
    public $defaultsConfigPath;

    abstract public function get($name, $default=NULL);
    abstract public function set($name, $value);
    abstract public function delete($name);

    public function init()
    {
        if (is_null($this->prefix)) {
            $this->prefix = ytg_Core::$app->prefix . '_';
        }
    }

    public function has($name)
    {
        return FALSE === $this->get($name, FALSE);
    }

    public function __get($name)
    {
        if ($this->canGetProperty($name)) {
            return parent::__get($name);
        }
        
        return $this->get($name);
    }

    public function __set($name, $value)
    {
        if ($this->canSetProperty($name)) {
            return parent::__set($name, $value);
        }
        
        return $this->set($name, $value);
    }

    public function __unset($name)
    {
        return $this->delete($name);
    }

    public function __isset($name)
    {
        return $this->has($name);
    }
}