<?php
ytg_Core::load('Framework_Component_OptionsAbstract');

class ytg_Framework_Component_Options
    extends ytg_Framework_Component_OptionsAbstract
{
    public $defaultsConfigPath = 'option/default';

    public function get($name, $default = NULL)
    {
        $result = get_option($this->prefix . $name, $default);

        if (is_null($result) && is_null($default)) {
            $result = ytg_Core::config("{$this->defaultsConfigPath}/{$name}");
        }

        return $result;
    }

    public function set($name, $value)
    {
        update_option($this->prefix . $name, $value);

        return $this;
    }

    public function delete($name)
    {
        return delete_option($this->prefix . $name);
    }
}