<?php
ytg_Core::load('Framework_Component_OptionsAbstract');

class ytg_Framework_Component_Meta
    extends ytg_Framework_Component_OptionsAbstract
{
    public $id;
    public $type = 'post';

    public function init()
    {
        parent::init();

        if (is_null($this->defaultsConfigPath)) {
            $this->defaultsConfigPath = "meta/{$this->type}/default";
        }
    }

    public function get($name, $default=NULL)
    {
        $result = get_metadata($this->type, $this->id,
            $this->prefix . $name, TRUE);
        if ('' == $result) {
            $result = $default;
        }

        if (is_null($result) && is_null($default)) {
            $result = ytg_Core::$app->getConfigValue(
                "{$this->defaultsConfigPath}/{$name}");
        }

        return $result;
    }

    public function set($name, $value)
    {
        update_metadata($this->type, $this->id, $this->prefix . $name,
            $value);

        return $this;
    }

    public function add($name, $value)
    {
        add_metadata($this->type, $this->id, $this->prefix . $name,
            $value);

        return $this;
    }

    public function delete($name)
    {
        delete_metadata($this->type, $this->id,
            $this->prefix . $name);

        return $this;
    }

    public function getAll($name, $default=NULL)
    {
        $result = get_metadata($this->type, $this->id,
            $this->prefix . $name);

        if (!$result && is_null($default)) {
            $result = ytg_Core::$app->getConfigValue(
                "{$this->_defaultsConfigPath}{$name}/all");
        }
        
        return $result;
    }

    public function replace($name, $oldValue, $value)
    {
        update_metadata($this->type, $this->id, $this->prefix . $name,
            $value, $oldValue);

        return $this;
    }
}