"use strict";

jQuery(function($) {
    function startRequest() {
        if (terminated) {
            return;
        }

        $.ajax({
            type: 'POST',
            url: ajaxurl + '?action=ytg&controller=admin&controllerAction=startProcess',
            data: {
                sessionId: ytg_progressData.sessionId,
                params: ytg_progressData.params
            },
            dataType: 'text',
            success: function(data) {
                if (!terminated && '' != data && '0' != data) {
                    if ('Another instance in running' == data) {
                        logAppend('<p class="error"><strong>Another instance running detected. Only one instance of the post generation process can run at the same time. Terminated the process.</strong></p>');
                        terminated = true;
                        if (progressTimeout) {
                            clearTimeout(progressTimeout);
                            progressTimeout = null;
                        }

                        statusUpdate('error', 'Another instance is running. Terminated.');
                    } else {
                        logAppend('<p class="ytg-error"><strong>Unexpected server response:</strong></p>'
                            + '<pre class="ytg-error">' + htmlEscape(data) + '</pre>');
                        statusUpdate('server-error',  'Unexpected error.');
                    }
                }
            },
            error: function(xhr, textStatus, errorThrown) {
                if ('abort' == textStatus) {
                    return;
                }

                logAppend('<p class="ytg-error"><strong>HTTP error ' + xhr.status + ':</strong> '
                    + xhr.statusText
                    + '</p>'
                    + '<pre class="ytg-error">' + htmlEscape(xhr.responseText) + '</pre>');

                statusUpdate('server-error', 'Unexpected error.');
            },
            complete: function(jqXHR, textStatus) {

            }
        });

        scheduleProgressRequest();
    }

    function progressRequest() {
        if (terminated) {
            return;
        }

        $.ajax({
            type: 'POST',
            url: ajaxurl + '?action=ytg&controller=admin&controllerAction=updateProgress',
            data: {
                logOffset: logOffset,
                sessionId: ytg_progressData.sessionId
            },
            dataType: 'json',
            success: function(data) {
                if (data.log) {
                    logAppend(data.log.content);
                    logOffset = data.log.offset;
                }

                if (data.status && '' != data.status.content) {
                    statusUpdate(data.status.name, data.status.content);
                }

                /*
                if (data.progress) {
                    progressUpdate(data.progress.percent, data.progress.label);
                }
                */

                if (terminated) {
                    return;
                }

                if (!data['terminated']) {
                    scheduleProgressRequest();
                } else {
                    terminated = true;
                }
            },
            error: function(xhr, textStatus, errorThrown) {
                if ('abort' == textStatus || terminated) {
                    return;
                }
                progressRetryCount++;
                if (progressRetryCount <= UPDATE_RETRY_COUNT) {
                    scheduleProgressRequest();
                    return;
                }

                logAppend('<p class="error"><strong>AJAX error:</strong> '
                    + textStatus
                    + '</p>');
            }
        });
    }

    function scheduleProgressRequest() {
        progressTimeout = setTimeout(progressRequest, UPDATE_INTERVAL);
    }

    function logAppend(html) {
        var $log = $('#ytg-log');

        $log.append(html);

        if ('' != html) {
            var scrollHeight = $log.prop('scrollHeight');
            if (windowActive) {
                $log.animate({scrollTop: scrollHeight}, 1000);
            } else {
                $log.scrollTop(scrollHeight);
            }
        }
    }

    function statusUpdate(name, content) {
        if ('error' == name || 'success' == name) {
            terminated = true;
        }

        $('.ytg-progress').attr('data-status', name);
        if (content !== undefined) {
            $('.ytg-status-text').html(content);
        }
    }

    function htmlEscape(text) {
        return $('<div>').text(text).html();
    }

    /**
     * Detect window focus
     */
    function onWindowFocus() {
        windowActive = true;
    };
    function onWindowBlur(){
        windowActive = false;
    };

    var UPDATE_INTERVAL = 3000;
    var UPDATE_RETRY_COUNT = 3;

    var logOffset = 0;
    var terminated = false;
    var progressRetryCount = 0;
    var windowActive = true;
    var progressTimeout = null;

    if (/*@cc_on!@*/false) { // check for Internet Explorer
        document.onfocusin = onWindowFocus;
        document.onfocusout = onWindowBlur;
    } else {
        window.onfocus = onWindowFocus;
        window.onblur = onWindowBlur;
    }

    // Init

    if (ytg_progressData.start) {
        startRequest();
    } else {
        progressRequest();
    }
});