<?php
/**
 * @var $this ytg_Framework_Component_View
 * @var $model ytg_Model_Form_Admin
 */
/** @var $model ytg_Model_Template */

$this->context->layoutParams['titleTools']
    .= $this->render('template/_form/title-tools', compact('model'));

$formName = $model->formName();

// Workaround for JetPack contact-form module bug
remove_filter('mce_external_plugins', array('Grunion_Editor_View', 'mce_external_plugins'));

?>
<form id="ytg-form-template"
      class="ytg-form ytg-form-template"
      action=""
      method="POST"
>
    <table class="form-table ytg-form-table">
        <tbody>

        <?php $attribute = 'name'; ?>
        <tr id="ytg-field-<?php echo $attribute; ?>">
            <th scope="row">
                <label for="ytg-input-<?php echo $attribute; ?>">
                    <span class="ytg-text">
                        <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>:
                    </span>
                </label>
            </th>
            <td>
                <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                       type="text"
                       id="ytg-input-<?php echo $attribute; ?>"
                       value="<?php echo $this->escape($model->$attribute); ?>"
                       class="regular-text"
                       <?php if (1 == $model->id): ?>disabled="disabled"<?php endif; ?>
                >
            </td>
        </tr>

        <?php $attribute = 'content'; ?>
        <tr id="ytg-field-<?php echo $attribute; ?>"-label>
            <th scope="row" colspan="2" class="ytg-full-row">
                <label for="ytg-input-<?php echo $attribute; ?>">
                    <span class="ytg-text">
                        <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>:
                    </span>
                </label>
            </th>
        </tr>
        <tr id="ytg-field-<?php echo $attribute; ?>">
            <td colspan="2" class="ytg-full-row">
                <div class="ytg-editor-container">
                    <?php $this->wysiwygEditor($model->$attribute, 'content',
                        ytg_Core::config('editor/options/default')); ?>
                </div>
                <?php /*
                <textarea name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                       id="ytg-input-<?php echo $attribute; ?>"
                       class="large-text"
                       rows="10"
                ><?php echo $this->escape($model->$attribute); ?></textarea>
                */ ?>
            </td>
        </tr>

        </tbody>
    </table>

    <div class="ytg-submit">
        <button type="submit"
                id="ytg-button-submit"
                class="button button-primary"
        >
            <?php if ($model->getIsNewRecord()): ?>
                Add New Template
            <?php else: ?>
                Save Template
            <?php endif; ?>
        </button>
    </div>
</form>

