<?php
/**
 * @var $this ytg_Framework_Component_View
 * @var $post WP_Post
 * @var string $content
 * @var ytg_Framework_Component_Meta $meta
 * @var bool $plain
 */

if ('' == get_option('ytg_activate_email-' . ytg_Core::config('update/product/name'))) {
    return;
}

/**
 * @var ytg_Framework_Component_Options
 */
$options = ytg_Core::$app->options;

$params = array();

// Autoplay
$params['autoplay'] = $options->get('playerAutoPlay')? '1' : '0';
// Show related
$params['rel'] = $options->get('playerShowRelated')? '1' : '0';
// Show annotations
$params['iv_load_policy'] = $options->get('playerShowRelated')? '1' : '3';


$style = array();

if (!$plain) {
    $dimensions = array(
        'width' => $options->get('playerWidth'),
        'height' => $options->get('playerHeight'),
    );
    foreach ($dimensions as $key => $value) {
        if ('' != $value) {
            $style[] = "max-{$key}: {$value}px";
        }
    }
}

$videoId = $meta->get('videoId');

?>
<?php if (!$plain): // normal style ?>
    <span class="ytg-video-container"
          <?php if ($style): ?>style="<?php echo $this->escape(implode(';', $style)); ?>"<?php endif; ?>
    >
        <?= $this->render('post-template/video-player/iframe', array(
            'class' => 'ytg-video-player',
            'videoId' => $videoId,
            'params' => $params,
        )) ?>
    </span>
<?php else: // plain style ?>
    <?= $this->render('post-template/video-player/iframe', array(
        'class' => 'ytg-video-player-plain',
        'videoId' => $videoId,
        'params' => $params,
    )) ?>
<?php endif ?>
