<?php
/**
 * @var $this ytg_Framework_Component_View
 * @var $model ytg_Model_Form_Metabox_Default
 */

$meta = $model->io;

ytg_Core::$app->assets->registerTemplatePreview();

$formName = $model->formName();
?>
<div id="ytg-messages">
    <?php if ($this->messages()->has()): ?>
        <?php foreach ($this->messages()->get() as $message): ?>
            <?php echo $this->render('layouts/admin/message', $message); ?>
        <?php endforeach; ?>
        <?php $this->messages()->clear(); ?>
    <?php endif; ?>
    <?php if ($message = $meta->get('onlywireError')): ?>
        <div class="notice notice-error">
            <p>Error sharing the post via Onlywire:
                <?php echo $this->escape($message); ?></p>
        </div>
    <?php endif; ?>
</div>
<div id="ytg-metabox-default"
    class="ytg-form ytg-metabox ytg-metabox-default"
>
    <?php $attribute = 'postTemplate'; ?>
    <h3>
        <span class="ytg-text">
            <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>:
        </span>
        <span class="ytg-help-link-container">
            (<a href="#" class="ytg-help-link" data-identifier="<?php echo $attribute; ?>">help</a>)
        </span>
    </h3>

    <div class="ytg-form-group ytg-field-<?php echo $attribute; ?>">
        <button type="submit"
                class="button button-primary ytg-submit"
        >
            Change post template and save
        </button>
        <?php $value = $model->$attribute; ?>
        <div class="ytg-input-template-container">
            <select name="<?php echo $model->formName(); ?>[<?php echo $attribute; ?>]"
                    id="ytg-input-<?php echo $attribute; ?>"
                    class="ytg-input-template"
            >
                <option value="">(default)</option>
                <?php foreach ($model->getPostTemplateList() as $key=>$label): ?>
                    <option value="<?php echo $key; ?>"
                            id="ytg-option-<?php echo $attribute; ?>-<?php echo $key; ?>"
                        <?php if ($key == $value): ?>
                            selected="selected"
                        <?php endif; ?>
                    ><?php echo $this->escape($label); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <button type="submit"
                class="button button-primary ytg-submit ytg-mobile"
        >
            Change post template and save
        </button>

        <?php echo $this->render('template/_preview-widget', array(
            'id' => $model->$attribute,
        )); ?>
    </div>
</div>

<div id="ytg-help-bkg"></div>

<?php
$helpPath = dirname(__FILE__) . "/{$this->context->actionName}/help/";

$tips = array();

foreach ($model->safeAttributes() as $attribute) {
    if ($model->getAttributeProperty($attribute, 'help')) {
        $tips[$attribute] = $model->getAttributeLabel($attribute);
    }
}

foreach ($tips as $id=>$label) {
    echo $this->render('_help/popup', array(
        'identifier' => $id,
        'title' => $label,
        'path' => $helpPath . $id . '.php',
    ));
}
