<?php
/**
 * @var $this ytg_Framework_Component_View
 * @var $announcement string
*/
?>
<div class="wrap ytg-admin-page" id="<?php echo isset($containerId)? $containerId : 'ytg-admin'; ?>">
    <?php if (isset($announcement) && '' != $announcement): ?>
        <div class="ytg-announcement">
            <?php echo $announcement; ?>
        </div>
    <?php endif; ?>

    <h1>
        <?php echo $this->escape(isset($title)
            ? $title
            : ytg_Core::config('plugin/title'));
        ?>
        <?php
        if (isset($titleTools)) {
            echo $titleTools;
        }
        ?>
    </h1>

    <?php if (!isset($displayMessages) || $displayMessages): ?>
        <div id="ytg-messages">
            <?php if ($this->messages()->has()): ?>
                <?php foreach ($this->messages()->get() as $message): ?>
                    <?php echo $this->render('layouts/admin/message', $message); ?>
                <?php endforeach; ?>
                <?php $this->messages()->clear(); ?>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <?php if (!isset($hideHeaderTabs) || !$hideHeaderTabs): ?>
        <?php echo $this->render('layouts/admin/header-tabs', compact('headerTabs', 'currentHeaderTab')); ?>
    <?php endif; ?>

    <?php echo $content; ?>

    <div id="ytg-help-bkg"></div>
</div>