<?php
/**
 * @var $this ytg_Framework_Component_View
 * @var $model ytg_Component_Client_Cpanel
 */

$formName = $model->formName();
?>
<div class="ytg-form-cpanel">
    <h3>Set up Cron Job with cPanel
        <button type="button" class="ytg-toggle button button-default">
            <?php if ($model->hasErrors()): ?>Hide<?php else: ?>Show<?php endif; ?>
        </button>
        <span class="ytg-help-link-container">
            (<a href="#" class="ytg-help-link" data-identifier="cron">help</a>)
        </span>
    </h3>

    <div class="ytg-internal"
         <?php if (!$model->hasErrors()): ?> style="display: none"<?php endif; ?>
    >
        <form id="ytg-form-cpanel"
              class="ytg-form"
              action=""
              method="POST"
        >
            <table class="form-table ytg-form-table">
                <tbody>

                <?php $attribute = 'username'; ?>
                <tr id="ytg-field-<?php echo $attribute; ?>">
                    <th scope="row">
                        <label for="ytg-input-<?php echo $attribute; ?>">
                            <span class="ytg-text">
                                <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>:
                            </span>
                        </label>
                    </th>
                    <td>
                        <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               type="text"
                               id="ytg-input-<?php echo $attribute; ?>"
                               value="<?php echo $this->escape($model->$attribute); ?>"
                               class="regular-text"
                               spellcheck="false"
                        >
                    </td>
                </tr>

                <?php $attribute = 'password'; ?>
                <tr id="ytg-field-<?php echo $attribute; ?>">
                    <th scope="row">
                        <label for="ytg-input-<?php echo $attribute; ?>">
                            <span class="ytg-text">
                                <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>:
                            </span>
                        </label>
                    </th>
                    <td>
                        <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               type="text"
                               id="ytg-input-<?php echo $attribute; ?>"
                               value="<?php echo $this->escape($model->$attribute); ?>"
                               class="regular-text"
                               spellcheck="false"
                        >
                    </td>
                </tr>
                </tbody>
            </table>

            <button type="submit"
                    class="button button-primary ytg-btn-submit"
            >
                Add Cron Job
            </button>
        </form>
    </div>
</div>