<?php
/**
 * @var $this ytg_Framework_Component_View
 * @var $model ytg_Model_Form_Admin
 */
/** @var $model ytg_Model_Channel */

ytg_Core::$app->assets->registerCategoryChecklist()
    ->registerTemplatePreview();

$this->context->layoutParams['titleTools']
    .= $this->render('channel/_form/title-tools', compact('model'));

/**
 * @var string $formName
 */
$formName = $model->formName();
?>
<form id="ytg-form-channel"
      class="ytg-form ytg-form-channel"
      action=""
      method="POST"
>
    <table class="form-table ytg-form-table">
        <tbody>

        <?php $attribute = 'name'; ?>
        <tr id="ytg-field-<?php echo $attribute; ?>">
            <th scope="row">
                <label for="ytg-input-<?php echo $attribute; ?>">
                    <span class="ytg-text">
                        <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>:
                    </span>
                </label>
            </th>
            <td>
                <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                       type="text"
                       id="ytg-input-<?php echo $attribute; ?>"
                       value="<?php echo $this->escape($model->$attribute); ?>"
                       class="regular-text"
                >
            </td>
        </tr>

        <?php $attribute = 'youtube_id'; ?>
        <tr id="ytg-field-<?php echo $attribute; ?>">
            <th scope="row">
                <label for="ytg-input-<?php echo $attribute; ?>">
                    <span class="ytg-text">
                        <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>:
                    </span>
                </label>
            </th>
            <td>
                <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                       type="text"
                       id="ytg-input-<?php echo $attribute; ?>"
                       value="<?php echo $this->escape($model->$attribute); ?>"
                       class="regular-text"
                >
            </td>
        </tr>

        <?php $attribute = 'keyword'; ?>
        <tr id="ytg-field-<?php echo $attribute; ?>"
            class="ytg-field-<?php echo $attribute; ?>"
        >
            <th scope="row">
                <label for="ytg-input-<?php echo $attribute; ?>">
                    <span class="ytg-text">
                        <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>:
                    </span>
                </label>
            </th>
            <td>
                <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                       type="text"
                       id="ytg-input-<?php echo $attribute; ?>"
                       value="<?php echo $this->escape($model->$attribute); ?>"
                       class="ytg-form-control regular-text"
                >
            </td>
        </tr>

        <?php $attribute = 'negative_keywords'; ?>
        <tr id="ytg-field-<?php echo $attribute; ?>"
            class="ytg-field-negativeKeywords"
        >
            <th scope="row">
                <label for="ytg-input-<?php echo $attribute; ?>">
                    <span class="ytg-text">
                        <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>:
                    </span>
                </label>
            </th>
            <td>
                <textarea name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                          id="ytg-input-<?php echo $attribute; ?>"
                          value="<?php echo $this->escape($model->$attribute); ?>"
                          class="ytg-form-control regular-text<?php if ('' == $model->keyword): ?> disabled<?php endif; ?>"
                          rows="3"
                ><?php echo $this->escape($model->$attribute); ?></textarea>
                <span class="ytg-no-effect description"
                      <?php if ('' != $model->keyword): ?>style="display: none"<?php endif; ?>
                >
                    <br>Negative keywords have no effect if main keyword is empty.
                </span>
            </td>
        </tr>

        <?php $attribute = 'template_id'; ?>
        <tr id="ytg-field-<?php echo $attribute; ?>">
            <th scope="row">
                <label for="ytg-input-<?php echo $attribute; ?>">
                    <span class="ytg-text">
                        <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>:
                    </span>
                </label>
            </th>
            <td>
                <?php $value = $model->$attribute; ?>
                <select name="<?php echo $model->formName(); ?>[<?php echo $attribute; ?>]"
                        id="ytg-input-<?php echo $attribute; ?>"
                        class="regular-text ytg-input-template"
                >
                    <option value="">(default)</option>
                    <?php foreach ($model->getTemplateList() as $key=>$label): ?>
                        <option value="<?php echo $key; ?>"
                                id="ytg-option-<?php echo $attribute; ?>-<?php echo $key; ?>"
                            <?php if ($key == $value): ?>
                                selected="selected"
                            <?php endif; ?>
                        ><?php echo $this->escape($label); ?></option>
                    <?php endforeach; ?>
                </select>
                <?php echo $this->render('template/_preview-widget', array(
                    'id' => $model->$attribute,
                )); ?>
            </td>
        </tr>

        <?php $attribute = 'categories'; ?>
        <tr id="ytg-field-<?php echo $attribute; ?>">
            <th scope="row">
                <label for="ytg-input-<?php echo $attribute; ?>">
                    <span class="ytg-text">
                        <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>:
                    </span>
                </label>
            </th>
            <td>
                <?php echo $this->render('admin/index/post-categories', array(
                    'value' => $model->$attribute,
                )); ?>
                <div class="ytg-category-adder">
                    <a class="ytg-button-category-adder-toggle hide-if-no-js" href="#">
                        + Add New Category
                    </a>

                    <div class="ytg-category-adder-group"
                         style="display: none"
                    >
                        <input type="text"
                               class="ytg-input-name ytg-form-control"
                               value=""
                        />
                        <div class="ytg-parent-category-dropdown">
                            <?php echo $this->render('admin/index/parent-category-dropdown'); ?>
                        </div>
                        <button type="button"
                                class="button ytg-category-adder-submit"
                        >
                            Add New Category
                        </button>
                        <div class="ytg-ajax-indicator"
                             title="Adding new category..."
                             alt="Loading..."
                        ></div>
                    </div>
                </div>
            </td>
        </tr>

        <?php
        $attribute = 'post_type';
        $value = $model->$attribute;
        $postTypes = ytg_Core::$app->postTypes->getContentTypes();
        ?>
        <?php if (count($postTypes) > 1): ?>
            <tr id="ytg-field-<?php echo $attribute; ?>"
                class="ytg-field-<?php echo $attribute; ?>"
            >
                <th scope="row">
                    <label for="ytg-input-<?php echo $attribute; ?>">
                        <span class="ytg-text">
                            <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>:
                        </span>
                    </label>
                </th>
                <td>
                    <ul class="ytg-radio">
                        <?php foreach ($model->getAttributeList($attribute) as $key=>$label): ?>
                            <?php
                            $optionId = "{$formName}-{$attribute}-{$key}";
                            ?>
                            <li>
                                <label for="<?php echo $optionId; ?>"
                                       class="ytg-control-label-radio ytg-option-<?php echo $key; ?>"
                                >
                                    <input type="radio"
                                           name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                                           id="<?php echo $optionId; ?>"
                                           class="ytg-form-control-option"
                                           value="<?php echo $this->escape($key); ?>"
                                           <?php if ($value == $key): ?>checked="checked"<?php endif; ?>
                                    >
                                    <span class="ytg-text">
                                        <?php echo $this->escape($label); ?>
                                    </span>
                                </label>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </td>
            </tr>
        <?php endif; ?>

        </tbody>
    </table>

    <?php if (1 == count($postTypes)): ?>
        <?php
        reset($postTypes);
        $value = current($postTypes);
        ?>
        <input type="hidden"
               name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
               id="<?php echo $formName; ?>-<?php echo $attribute; ?>"
               value="<?php echo $this->escape($value); ?>"
        >
    <?php endif; ?>

    <div class="ytg-submit">
        <button type="submit"
                id="ytg-button-submit"
                class="button button-primary"
        >
            <?php if ($model->getIsNewRecord()): ?>
                Add New Channel
            <?php else: ?>
                Save Channel
            <?php endif; ?>
        </button>
    </div>
</form>