<?php
/**
 * @var $this ytg_Framework_Component_View
 * @var $model ytg_Model_Form_Admin
 */

wp_enqueue_script('ytg-progress',
    ytg_Core::$app->baseUrl . 'assets/js/progress.js',
    array('jquery'),
    ytg_Core::$app->version,
    TRUE);
wp_enqueue_style('ytg-progress',
    ytg_Core::$app->baseUrl . 'assets/css/progress.css',
    array(),
    ytg_Core::$app->version);

$progressData = array(
    'ajaxRetryMax' => 3,
    'updateTimeout' => 3000,
    'sessionId' => session_id(),
    'start' => (bool)$model,
    'params' => $params,
);

$this->context->layoutParams['currentHeaderTab'] = 'admin';
?>

<div class="ytg-progress" data-status="init">
    <div class="ytg-status">
        <h3>
            <div class="ytg-animation"></div>
            <span class="ytg-status-text">Initializing...</span>
            <a class="ytg-button-cancel add-new-h2 button"
               href="<?php echo $this->adminUrl(array('action' => 'terminate')); ?>"
            >
                Cancel
            </a>
            <a class="ytg-button-back add-new-h2 button"
               href="<?php echo $this->adminUrl(array()); ?>"
            >
                &lt; Back
            </a>
        </h3>
    </div>

    <div id="ytg-log" class="ytg-log"></div>

    <div class="ytg-footer-note">
        <hr>
        You can see your posts <a target="_blank" href="<?php echo $this->escape(admin_url('edit.php')); ?>">here</a>.
    </div>

    <script type="text/javascript">
        var ytg_progressData = <?php echo json_encode($progressData); ?>;
    </script>
</div>
