<?php
/**
 * @var $this ytg_Framework_Component_View
 * @var $model ytg_Model_Form_Options
 */

$this->context->layoutParams['currentHeaderTab'] = 'options';
$this->context->layoutParams['title'] .= ': Options';

$formName = $model->formName();
?>

<div class="ytg-form-options">
    <form action="" method="POST" class="ytg-form" id="ytg-form-options">

        <h3>Post-Generation Options</h3>

        <table class="form-table">
            <tbody>

            <?php $attribute = 'youtubeApiKey'; ?>
            <tr id="ytg-field-<?php echo $attribute; ?>">
                <th scope="row">
                    <label for="ytg-input-<?php echo $attribute; ?>">
                        <span class="ytg-text">
                            <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>
                        </span>
                    </label>
                </th>
                <td>
                    <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                           type="text"
                           id="ytg-input-<?php echo $attribute; ?>"
                           value="<?php echo $this->escape($model->$attribute); ?>"
                           class="regular-text"
                           spellcheck="false"
                    >
                    <span class="ytg-help-link-container">
                        <a href="https://helpcenterhq.com/knowledgebase.php?article=167" target="_blank">Watch a quick video on how to get your YouTube API Key</a>
                    </span>
                </td>
            </tr>

            <?php $attribute = 'generatorFeaturedImages'; ?>
            <tr id="ytg-field-<?php echo $attribute; ?>">
                <th scope="row" colspan="2">
                    <label for="ytg-input-<?php echo $attribute; ?>">
                        <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               type="hidden"
                               value="0"
                        >
                        <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               type="checkbox"
                               id="ytg-input-<?php echo $attribute; ?>"
                               value="1"
                               <?php if ($model->$attribute): ?>checked="checked"<?php endif; ?>
                        >
                        <span class="ytg-text">
                            <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>
                        </span>
                        <span class="ytg-help-link-container">
                            (<a href="#" class="ytg-help-link" data-identifier="<?php echo $attribute; ?>">help</a>)
                        </span>
                    </label>
                </th>
            </tr>

            <?php if ('pro' == ytg_Core::config('edition')): ?>
                <?php $attribute = 'generatorRemoveLinks'; ?>
                <tr id="ytg-field-<?php echo $attribute; ?>">
                    <th scope="row" colspan="2">
                        <label for="ytg-input-<?php echo $attribute; ?>">
                            <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                                   type="hidden"
                                   value="0"
                            >
                            <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                                   type="checkbox"
                                   id="ytg-input-<?php echo $attribute; ?>"
                                   value="1"
                                   <?php if ($model->$attribute): ?>checked="checked"<?php endif; ?>
                            >
                            <span class="ytg-text">
                                <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>
                            </span>
                            <span class="ytg-help-link-container">
                                (<a href="#" class="ytg-help-link" data-identifier="<?php echo $attribute; ?>">help</a>)
                            </span>
                        </label>
                    </th>
                </tr>
            <?php endif; ?>

            <?php if ('pro' == ytg_Core::config('edition')): ?>
                <?php $attribute = 'generatorFetchComments'; ?>
                <tr id="ytg-field-<?php echo $attribute; ?>">
                    <th scope="row" colspan="2">
                        <label for="ytg-input-<?php echo $attribute; ?>">
                            <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                                   type="hidden"
                                   value="0"
                            >
                            <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                                   type="checkbox"
                                   id="ytg-input-<?php echo $attribute; ?>"
                                   value="1"
                                   <?php if ($model->$attribute): ?>checked="checked"<?php endif; ?>
                            >
                            <span class="ytg-text">
                                <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>
                            </span>
                            <span class="ytg-help-link-container">
                                (<a href="#" class="ytg-help-link" data-identifier="<?php echo $attribute; ?>">help</a>)
                            </span>
                        </label>
                    </th>
                </tr>
            <?php endif; ?>

            </tbody>
        </table>

        <hr>
        <h3>
            Display Options
        </h3>

        <table class="form-table">
            <tbody>

            <tr id="ytg-field-playerDimensions">
                <th scope="row">
                    <span class="ytg-group-label">Video Dimensions:</span>
                </th>
                <td>
                    <?php $attribute = 'playerWidth'; ?>
                    <label for="ytg-input-<?php echo $attribute; ?>" class="ytg-before">
                        Max Width:
                    </label>
                    <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                           type="text"
                           id="ytg-input-<?php echo $attribute; ?>"
                           value="<?php echo $this->escape($model->$attribute); ?>"
                           class="ytg-input-inline"
                    >
                    <label for="ytg-input-<?php echo $attribute; ?>" class="ytg-after">
                        px.
                    </label>

                    <br>

                    <?php $attribute = 'playerHeight'; ?>
                    <label for="ytg-input-<?php echo $attribute; ?>" class="ytg-before">
                        Max Height:
                    </label>
                    <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                           type="text"
                           id="ytg-input-<?php echo $attribute; ?>"
                           value="<?php echo $this->escape($model->$attribute); ?>"
                           class="ytg-input-inline"
                    >
                    <label for="ytg-input-<?php echo $attribute; ?>">
                        px.
                    </label>
                </td>
            </tr>

            <?php $attribute = 'displaySuppressFeaturedImage'; ?>
            <tr id="ytg-field-<?php echo $attribute; ?>">
                <th scope="row" colspan="2">
                    <label for="ytg-input-<?php echo $attribute; ?>">
                        <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               type="hidden"
                               value="0"
                        >
                        <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               type="checkbox"
                               id="ytg-input-<?php echo $attribute; ?>"
                               value="1"
                               <?php if ($model->$attribute): ?>checked="checked"<?php endif; ?>
                        >
                        <span class="ytg-text">
                            <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>
                        </span>
                        <span class="ytg-help-link-container">
                            (<a href="#" class="ytg-help-link" data-identifier="<?php echo $attribute; ?>">help</a>)
                        </span>
                    </label>
                </th>
            </tr>

            <?php $attribute = 'playerAutoPlay'; ?>
            <tr id="ytg-field-<?php echo $attribute; ?>">
                <th scope="row" colspan="2">
                    <label for="ytg-input-<?php echo $attribute; ?>">
                        <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               type="hidden"
                               value="0"
                        >
                        <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               type="checkbox"
                               id="ytg-input-<?php echo $attribute; ?>"
                               value="1"
                               <?php if ($model->$attribute): ?>checked="checked"<?php endif; ?>
                        >
                        <span class="ytg-text">
                            <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>
                        </span>
                    </label>
                </th>
            </tr>

            <?php $attribute = 'playerShowRelated'; ?>
            <tr id="ytg-field-<?php echo $attribute; ?>">
                <th scope="row" colspan="2">
                    <label for="ytg-input-<?php echo $attribute; ?>">
                        <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               type="hidden"
                               value="0"
                        >
                        <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               type="checkbox"
                               id="ytg-input-<?php echo $attribute; ?>"
                               value="1"
                               <?php if ($model->$attribute): ?>checked="checked"<?php endif; ?>
                        >
                        <span class="ytg-text">
                            <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>
                        </span>
                    </label>
                </th>
            </tr>

            <?php $attribute = 'playerShowAnnotations'; ?>
            <tr id="ytg-field-<?php echo $attribute; ?>">
                <th scope="row" colspan="2">
                    <label for="ytg-input-<?php echo $attribute; ?>">
                        <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               type="hidden"
                               value="0"
                        >
                        <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               type="checkbox"
                               id="ytg-input-<?php echo $attribute; ?>"
                               value="1"
                               <?php if ($model->$attribute): ?>checked="checked"<?php endif; ?>
                        >
                        <span class="ytg-text">
                            <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>
                        </span>
                    </label>
                </th>
            </tr>

            </tbody>
        </table>

        <?php if ('pro' == ytg_Core::config('edition')): ?>
            <hr>
            <h3>
                Link-Cloaking Options
            </h3>

            <table class="form-table">
                <tbody>

                <?php $attribute = 'displayCloakLinks'; ?>
                <tr id="ytg-field-<?php echo $attribute; ?>">
                    <th scope="row" colspan="2">
                        <label for="ytg-input-<?php echo $attribute; ?>">
                            <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                                   type="hidden"
                                   value="0"
                            >
                            <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                                   type="checkbox"
                                   id="ytg-input-<?php echo $attribute; ?>"
                                   value="1"
                                   <?php if ($model->$attribute): ?>checked="checked"<?php endif; ?>
                            >
                            <span class="ytg-text">
                                <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>
                            </span>
                            <span class="ytg-help-link-container">
                                (<a href="#" class="ytg-help-link" data-identifier="<?php echo $attribute; ?>">help</a>)
                            </span>
                        </label>
                    </th>
                </tr>

                <?php $attribute = 'displayCloakingDirectory'; ?>
                <tr id="ytg-field-<?php echo $attribute; ?>">
                    <th scope="row">
                        <label for="ytg-input-<?php echo $attribute; ?>">
                            <span class="ytg-text">
                                <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>
                            </span>
                        </label>
                    </th>
                    <td>
                        <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               type="text"
                               id="ytg-input-<?php echo $attribute; ?>"
                               value="<?php echo $this->escape($model->$attribute); ?>"
                               class="regular-text"
                               <?php if (!$model->displayCloakLinks): ?>disabled="disabled"<?php endif; ?>
                        >
                    </td>
                </tr>

                </tbody>
            </table>

            <hr>
            <h3>
                Text-Spinning Options
                <span class="ytg-help-link-container">
                    (<a href="#" class="ytg-help-link" data-identifier="spinrewriter">help</a>)
                </span>
            </h3>

            <table class="form-table">
                <tbody>

                <?php $attribute = 'spinrewriterEmail'; ?>
                <tr id="ytg-field-<?php echo $attribute; ?>">
                    <th scope="row">
                        <label for="ytg-input-<?php echo $attribute; ?>">
                            <span class="ytg-text">
                                <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>
                            </span>
                        </label>
                    </th>
                    <td>
                        <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               type="text"
                               id="ytg-input-<?php echo $attribute; ?>"
                               value="<?php echo $this->escape($model->$attribute); ?>"
                               class="regular-text"
                               spellcheck="false"
                        >
                    </td>
                </tr>

                <?php $attribute = 'spinrewriterApiKey'; ?>
                <tr id="ytg-field-<?php echo $attribute; ?>">
                    <th scope="row">
                        <label for="ytg-input-<?php echo $attribute; ?>">
                            <span class="ytg-text">
                                <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>
                            </span>
                        </label>
                    </th>
                    <td>
                        <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               type="text"
                               id="ytg-input-<?php echo $attribute; ?>"
                               value="<?php echo $this->escape($model->$attribute); ?>"
                               class="regular-text"
                               spellcheck="false"
                        >
                    </td>
                </tr>

                <?php $attribute = 'spinrewriterProtectedTerms'; ?>
                <tr id="ytg-field-<?php echo $attribute; ?>">
                    <th scope="row">
                        <label for="ytg-input-<?php echo $attribute; ?>">
                            <span class="ytg-text">
                                <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>
                            </span>
                            <span class="ytg-help-link-container">
                                (<a href="#" class="ytg-help-link" data-identifier="<?php echo $attribute; ?>">help</a>)
                            </span>
                        </label>
                    </th>
                    <td>
                        <textarea name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               type="text"
                               id="ytg-input-<?php echo $attribute; ?>"
                               class="regular-text"
                               rows="4"
                        ><?php echo $this->escape($model->$attribute); ?></textarea>
                    </td>
                </tr>

                <?php $attribute = 'spinrewriterConfidenceLevel'; ?>
                <tr id="ytg-field-<?php echo $attribute; ?>">
                    <th scope="row">
                        <label for="ytg-input-<?php echo $attribute; ?>">
                            <span class="ytg-text">
                                <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>
                            </span>
                            <span class="ytg-help-link-container">
                                (<a href="#" class="ytg-help-link" data-identifier="<?php echo $attribute; ?>">help</a>)
                            </span>
                        </label>
                    </th>
                    <td>
                        <?php $value = $model->$attribute; ?>
                        <ul class="ytg-radio">
                            <?php foreach ($model->getAttributeList($attribute) as $key=>$label): ?>
                                <li>
                                    <label for="ytg-input-<?php echo $attribute; ?>-<?php echo $key; ?>">
                                        <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                                               type="radio"
                                               id="ytg-input-<?php echo $attribute; ?>-<?php echo $key; ?>"
                                               value="<?php echo $key; ?>"
                                               <?php if ($value == $key): ?>checked="checked"<?php endif; ?>
                                        >
                                            <span class="ytg-text">
                                                <?php echo $this->escape($label); ?>
                                            </span>
                                    </label>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </td>
                </tr>

                <?php $attribute = 'spinrewriterDisable'; ?>
                <tr id="ytg-field-<?php echo $attribute; ?>">
                    <th scope="row" colspan="2">
                        <label for="ytg-input-<?php echo $attribute; ?>">
                            <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                                   type="hidden"
                                   value="0"
                            >
                            <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                                   type="checkbox"
                                   id="ytg-input-<?php echo $attribute; ?>"
                                   value="1"
                                   <?php if ($model->$attribute): ?>checked="checked"<?php endif; ?>
                            >
                            <span class="ytg-text">
                                <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>
                            </span>
                        </label>
                    </th>
                </tr>

                </tbody>
            </table>

            <hr>
            <h3>
                Backlink Options
                <span class="ytg-help-link-container">
                    (<a href="#" class="ytg-help-link" data-identifier="onlywire">help</a>)
                </span>
            </h3>

            <table class="form-table">
                <tbody>

                <?php $attribute = 'onlywireUsername'; ?>
                <tr id="ytg-field-<?php echo $attribute; ?>">
                    <th scope="row">
                        <label for="ytg-input-<?php echo $attribute; ?>">
                            <span class="ytg-text">
                                <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>
                            </span>
                        </label>
                    </th>
                    <td>
                        <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               type="text"
                               id="ytg-input-<?php echo $attribute; ?>"
                               value="<?php echo $this->escape($model->$attribute); ?>"
                               class="regular-text"
                               spellcheck="false"
                        >
                    </td>
                </tr>

                <?php $attribute = 'onlywirePassword'; ?>
                <tr id="ytg-field-<?php echo $attribute; ?>">
                    <th scope="row">
                        <label for="ytg-input-<?php echo $attribute; ?>">
                            <span class="ytg-text">
                                <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>
                            </span>
                        </label>
                    </th>
                    <td>
                        <input name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               type="text"
                               id="ytg-input-<?php echo $attribute; ?>"
                               value="<?php echo $this->escape($model->$attribute); ?>"
                               class="regular-text"
                               spellcheck="false"
                        >
                    </td>
                </tr>

                <?php if ($model->hasOnlywireServices): ?>
                    <?php
                    $attribute = 'onlywireServices';
                    $value = $model->$attribute;
                    ?>
                    <tr id="ytg-field-<?php echo $attribute; ?>">
                        <th scope="row">
                            <label class="ytg-control-label" for="ytg-input-<?php echo $attribute; ?>">
                                <span class="ytg-text">
                                    <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>:
                                </span>
                                <span class="ytg-help-link-container">
                                    (<a href="#" class="ytg-help-link" data-identifier="<?php echo $attribute; ?>">help</a>)
                                </span>
                            </label>
                            <?php if ($model->onlywireServiceList): ?>
                                <label id="<?php echo $attribute; ?>-select-label"
                                       for="<?php echo $attribute; ?>-select"
                                       class="ytg-select-all"
                                >
                                    <input type="checkbox"
                                           id="<?php echo $attribute; ?>-select"
                                           data-ytg-select-all="#ytg-input-<?php echo $attribute; ?>"
                                           <?php if ($value): ?>checked="checked"<?php endif; ?>
                                    >
                                        <span class="ytg-text">
                                            Select All
                                        </span>
                                </label>
                            <?php endif; ?>
                            <button type="submit"
                                    class="button-secondary action-button ytg-btn-refresh-onlywire-services"
                                    name="action"
                                    value="refresh-onlywire-services"
                            >
                                Refresh List
                            </button>
                        </th>
                        <td>
                            <?php if (isset($model->errors['onlywire'])): ?>
                                <p class="ytg-no-profiles description ytg-error">
                                    <?php echo $this->escape($model->errors['onlywire']); ?>
                                </p>
                            <?php elseif ($model->onlywireServiceList): ?>
                                <ul class="ytg-checklist ytg-onlywire-services"
                                    id="ytg-input-<?php echo $attribute; ?>">
                                    <?php foreach ($model->onlywireServiceList as $group): ?>
                                        <li id="<?php echo $attribute; ?>-group-<?php echo $this->escape($group['name']); ?>">
                                            <h4>
                                                <label id="<?php echo $attribute; ?>-group-<?php echo $this->escape($group['name']); ?>-select-label"
                                                       for="<?php echo $attribute; ?>-group-<?php echo $this->escape($group['name']); ?>-select"
                                                >
                                                    <input type="checkbox"
                                                           id="<?php echo $attribute; ?>-group-<?php echo $this->escape($group['name']); ?>-select"
                                                           data-ytg-select-all="#<?php echo $attribute; ?>-group-<?php echo $this->escape($group['name']); ?>-items"
                                                           <?php if (array_intersect(array_keys($group['items']), $value)): ?>checked="checked"<?php endif; ?>
                                                    >
                                                        <span class="asg-label-text">
                                                            <?php echo $this->escape($group['label']); ?>:
                                                        </span>
                                                </label>
                                            </h4>

                                            <ul id="<?php echo $attribute; ?>-group-<?php echo $this->escape($group['name']); ?>-items">
                                                <?php foreach ($group['items'] as $key=>$label): ?>
                                                    <?php $id = 'ytg-input-' . $this->escape("{$attribute}-{$key}"); ?>
                                                    <li id="<?php echo $id; ?>-container">
                                                        <label id="<?php echo $id; ?>-label"
                                                               for="<?php echo $id; ?>"
                                                        >
                                                            <input type="checkbox"
                                                                   name="<?php echo $formName; ?>[<?php echo $attribute; ?>][<?php echo $this->escape($key); ?>]"
                                                                   id="<?php echo $id; ?>"
                                                                   value="<?php echo $this->escape($key); ?>"
                                                                <?php if (in_array($key, $value)): ?>
                                                                    checked="checked"
                                                                <?php endif; ?>
                                                            >
                                                                <span class="asg-label-text">
                                                                    <?php echo $this->escape($label); ?>
                                                                </span>
                                                        </label>
                                                    </li>
                                                <?php endforeach; ?>
                                            </ul>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php else: ?>
                                <p class="ytg-no-profiles description">You don't have any
                                    social network profiles registered with OnlyWire
                                    yet.<br>
                                    Please go to to <a href="https://onlywire.com/secure/networks" target="_blank">OnlyWire</a>
                                    and add profiles you would like to post to.</p>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endif; ?>

                </tbody>
            </table>
        <?php endif; ?>

        <div class="ytg-submit">
            <button type="submit"
                    id="ytg-button-submit"
                    class="button button-primary"
            >
                Save Options
            </button>
        </div>
    </form>
</div>

<?php
$helpPath = dirname(__FILE__) . "/{$this->context->actionName}/help/";

$tips = array(
    'spinrewriter' => 'Text-Spinning Options',
    'onlywire' => 'Backlink Options',
);

foreach ($model->safeAttributes() as $attribute) {
    if ($model->getAttributeProperty($attribute, 'help')) {
        $tips[$attribute] = $model->getAttributeLabel($attribute);
    }
}

foreach ($tips as $id => $label) {
    echo $this->render('_help/popup', array(
        'identifier' => $id,
        'title' => $label,
        'path' => $helpPath . $id . '.php',
    ));
}