<?php
/**
 * @var $this ytg_Framework_Component_View
 * @var $model ytg_Model_Form_Admin
 * @var $errors array
 */

ytg_Core::$app->assets->registerCategoryChecklist()
    ->registerTemplatePreview();

$this->context->layoutParams['currentHeaderTab'] = 'admin';

foreach ($errors as $key=>$params) {
    if (!is_array($params)) {
        $params = array();
    }

    echo $this->render("admin/index/error/{$key}", $params);
}

$formName = $model->formName();

$searchMode = $model->searchMode;
?>
<div class="ytg-form ytg-form-admin">
    <form id="ytg-form-admin"
        action="<?php echo $_SERVER['REQUEST_URI']; ?>"
        method="post"
    >
        <input type="hidden"
               id="ytg-input-allowTextSpinningOff"
               name="allowTextSpinningOff"
               value="0"
        >
        <div class="ytg-form-columns">
            <!-- 1st column -->
            <div class="ytg-form-column ytg-form-column-1">
                <h3>Filtering Options:</h3>

                <?php
                $attribute = 'searchMode';
                $value = $model->$attribute;
                ?>
                <div class="ytg-form-group ytg-field-<?php echo $attribute; ?>">
                    <?php foreach ($model->getAttributeList($attribute) as $key=>$label): ?>
                        <?php
                        $optionId = "{$formName}-{$attribute}-{$key}";
                        ?>
                        <label for="<?php echo $optionId; ?>"
                               class="ytg-control-label-radio ytg-option-<?php echo $key; ?>"
                        >
                            <input type="radio"
                                   name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                                   id="<?php echo $optionId; ?>"
                                   class="ytg-form-control-option ytg-<?php echo $attribute; ?>-option"
                                   value="<?php echo $key; ?>"
                                   <?php if ($value == $key): ?>checked="checked"<?php endif; ?>
                            >
                            <span class="ytg-text">
                                <?php echo $this->escape($label); ?>
                            </span>

                            <span class="ytg-help-link-container">
                                (<a href="#" class="ytg-help-link" data-identifier="<?php echo $attribute; ?>-<?php echo $key; ?>">help</a>)
                            </span>
                        </label>
                    <?php endforeach; ?>
                </div>

                <div class="ytg-searchMode-specific"
                     data-value="keyword"
                     <?php if('keyword' != $searchMode): ?>style="display: none;"<?php endif; ?>
                >
                    <?php
                    $attribute = 'keyword';
                    $id = "{$formName}-{$attribute}";
                    ?>
                    <div class="ytg-form-group ytg-field-<?php echo $attribute; ?><?php if ($model->isAttributeRequired($attribute)): ?> ytg-required<?php endif; ?>">
                        <label for="<?php echo $id; ?>"
                               class="ytg-control-label"
                        >
                            <span class="ytg-text">
                                <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>:
                            </span>
                            <span class="ytg-help-link-container">
                                (<a href="#" class="ytg-help-link" data-identifier="<?php echo $attribute; ?>">help</a>)
                            </span>
                        </label>
                        <input type="text"
                               name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               id="<?php echo $id; ?>"
                               class="ytg-form-control"
                               value="<?php echo $this->escape($model->$attribute); ?>"
                        >
                    </div>

                    <?php
                    $attribute = 'negativeKeywords';
                    $id = "{$formName}-{$attribute}";
                    ?>
                    <div class="ytg-form-group ytg-field-<?php echo $attribute; ?><?php if ($model->isAttributeRequired($attribute)): ?> ytg-required<?php endif; ?>">
                        <label for="<?php echo $id; ?>"
                               class="ytg-control-label"
                        >
                            <span class="ytg-text">
                                <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>:
                            </span>
                            <span class="ytg-help-link-container">
                                (<a href="#" class="ytg-help-link" data-identifier="<?php echo $attribute; ?>">help</a>)
                            </span>
                        </label>
                        <textarea name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               id="<?php echo $id; ?>"
                               class="ytg-form-control<?php if ('' == $model->keyword): ?> disabled<?php endif; ?>"
                               rows="3"
                        ><?php echo $this->escape($model->$attribute); ?></textarea>
                        <p class="ytg-no-effect description"
                              <?php if ('' != $model->keyword): ?>style="display: none"<?php endif; ?>
                        >
                            Negative keywords have no effect if the main keyword is empty.
                        </p>
                    </div>

                    <?php
                    $attribute = 'channels';
                    $id = "{$formName}-{$attribute}";
                    ?>
                    <div class="ytg-form-group ytg-field-<?php echo $attribute; ?><?php if ($model->isAttributeRequired($attribute)): ?> ytg-required<?php endif; ?>">
                        <label for="<?php echo $id; ?>"
                               class="ytg-control-label"
                        >
                            <span class="ytg-text">
                                <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>:
                            </span>
                            <span class="ytg-help-link-container">
                                (<a href="#" class="ytg-help-link" data-identifier="<?php echo $attribute; ?>">help</a>)
                            </span>
                        </label>
                        <textarea name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                                  id="<?php echo $id; ?>"
                                  class="ytg-form-control"
                                  rows="3"
                        ><?php echo $this->escape($model->$attribute); ?></textarea>
                        <p class="description">Please enter a <strong>channel</strong> ID - not a <strong>video</strong> ID.</p>
                    </div>

                    <?php
                    $attribute = 'sortOrder';
                    $id = "{$formName}-{$attribute}";
                    $value = $model->$attribute;
                    ?>
                    <div class="ytg-form-group ytg-field-<?php echo $attribute; ?>">
                        <label for="<?php echo $id; ?>"
                               class="ytg-control-label-inline"
                        >
                            <span class="ytg-text">
                                <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>:
                            </span>
                        </label>
                        <select name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                                id="<?php echo $id; ?>"
                                class="ytg-inline"
                        >
                            <?php foreach ($model->getAttributeList($attribute) as $key=>$label): ?>
                                <option value="<?php echo $this->escape($key); ?>"
                                        <?php if ($key == $value): ?>selected="selected"<?php endif; ?>
                                >
                                    <?php echo $this->escape($label); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                        <label for="<?php echo $id; ?>"
                               id="<?php echo $id; ?>-label-after"
                               class="ytg-control-label-inline ytg-after"
                        >
                            <span class="ytg-help-link-container">
                                (<a href="#" class="ytg-help-link" data-identifier="<?php echo $attribute; ?>">help</a>)
                            </span>
                        </label>
                    </div>

                    <?php
                    $attribute = 'filterDuration';
                    $id = "{$formName}-{$attribute}";
                    $value = $model->$attribute;
                    ?>
                    <div class="ytg-form-group ytg-field-<?php echo $attribute; ?>">
                        <label for="<?php echo $id; ?>"
                               class="ytg-control-label-inline"
                        >
                            <span class="ytg-text">
                                <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>:
                            </span>
                        </label>
                        <select name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                                id="<?php echo $id; ?>"
                                class="ytg-inline"
                        >
                            <option value="">(any)</option>
                            <?php foreach ($model->getAttributeList($attribute) as $key=>$label): ?>
                                <option value="<?php echo $this->escape($key); ?>"
                                        <?php if ($key == $value): ?>selected="selected"<?php endif; ?>
                                >
                                    <?php echo $this->escape($label); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                        <label for="<?php echo $id; ?>"
                               id="<?php echo $id; ?>-label-after"
                               class="ytg-control-label-inline ytg-after"
                        >
                            <span class="ytg-help-link-container">
                                (<a href="#" class="ytg-help-link" data-identifier="<?php echo $attribute; ?>">help</a>)
                            </span>
                        </label>
                    </div>

                    <?php
                    $attribute = 'minViews';
                    $id = "{$formName}-{$attribute}";
                    ?>
                    <div class="ytg-form-group ytg-field-<?php echo $attribute; ?><?php if ($model->isAttributeRequired($attribute)): ?> ytg-required<?php endif; ?>">
                        <label for="<?php echo $id; ?>"
                               class="ytg-control-label-inline ytg-before"
                        >
                            <span class="ytg-text">
                                Show Videos With at Least
                            </span>
                        </label>
                        <input type="text"
                               name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               id="<?php echo $id; ?>"
                               class="ytg-inline"
                               value="<?php echo $this->escape($model->$attribute); ?>"
                        >
                        <label for="<?php echo $id; ?>"
                               id="<?php echo $id; ?>-label-after"
                               class="ytg-control-label-inline ytg-after"
                        >
                            <span class="ytg-text ytg-primary">
                                Views
                            </span>
                            <span class="ytg-help-link-container">
                                (<a href="#" class="ytg-help-link" data-identifier="<?php echo $attribute; ?>">help</a>)
                            </span>
                        </label>
                    </div>

                    <?php
                    $attribute = 'maxCount';
                    $id = "{$formName}-{$attribute}";
                    ?>
                    <div class="ytg-form-group ytg-field-<?php echo $attribute; ?><?php if ($model->isAttributeRequired($attribute)): ?> ytg-required<?php endif; ?>">
                        <label for="<?php echo $id; ?>"
                               class="ytg-control-label-inline"
                        >
                            <span class="ytg-text">
                                Fetch
                            </span>
                        </label>
                        <input type="text"
                               name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                               id="<?php echo $id; ?>"
                               class="ytg-inline"
                               value="<?php echo $this->escape($model->$attribute); ?>"
                        >
                        <label for="<?php echo $id; ?>"
                               id="<?php echo $id; ?>-label-after"
                               class="ytg-control-label-inline ytg-after"
                        >
                            <span class="ytg-text ytg-primary">
                                Total Videos
                            </span>
                            <span class="ytg-help-link-container">
                                (<a href="#" class="ytg-help-link" data-identifier="<?php echo $attribute; ?>">help</a>)
                            </span>
                        </label>
                    </div>
                </div>

                <div class="ytg-searchMode-specific"
                     data-value="ids"
                     <?php if('ids' != $searchMode): ?>style="display: none;"<?php endif; ?>
                >
                    <?php
                    $attribute = 'videoIdList';
                    $id = "{$formName}-{$attribute}";
                    ?>
                    <div class="ytg-form-group ytg-field-<?php echo $attribute; ?><?php if ($model->isAttributeRequired($attribute)): ?> ytg-required<?php endif; ?>">
                        <label for="<?php echo $id; ?>"
                               class="ytg-control-label"
                        >
                            <span class="ytg-text">
                                <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>:
                            </span>
                        </label>
                        <textarea name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                                  id="<?php echo $id; ?>"
                                  class="ytg-form-control"
                                  rows="20"
                        ><?php echo $this->escape($model->$attribute); ?></textarea>
                    </div>
                </div>
            </div>

            <!-- 2nd column -->
            <div class="ytg-form-column ytg-form-column-2">
                <h3>Scheduling Options:</h3>

                <?php
                $attribute = 'publicationMethod';
                $value = $model->$attribute;
                ?>
                <div class="ytg-form-group ytg-field-<?php echo $attribute; ?>">
                    <?php foreach ($model->getAttributeList($attribute) as $key=>$label): ?>
                        <?php
                        $optionId = "{$formName}-{$attribute}-{$key}";
                        ?>
                        <label for="<?php echo $optionId; ?>"
                               class="ytg-control-label-radio ytg-option-<?php echo $key; ?>"
                        >
                            <input type="radio"
                                   name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                                   id="<?php echo $optionId; ?>"
                                   class="ytg-form-control-option"
                                   value="<?php echo $key; ?>"
                                   <?php if ($value == $key): ?>checked="checked"<?php endif; ?>
                            >
                            <?php if ('schedule' == $key): ?>
                                <span class="ytg-text ytg-before">
                                    Schedule
                                </span>
                                <?php echo $this->render('admin/index/posts-per-week', compact('model', 'formName')); ?>
                                <span class="ytg-text ytg-after">
                                    posts per week
                                </span>
                            <?php else: ?>
                                <span class="ytg-text ytg-before">
                                    <?php echo $this->escape($label); ?>
                                </span>
                            <?php endif; ?>

                            <span class="ytg-help-link-container">
                                (<a href="#" class="ytg-help-link" data-identifier="<?php echo $attribute; ?>-<?php echo $key; ?>">help</a>)
                            </span>
                        </label>
                    <?php endforeach; ?>
                </div>

                <h3>
                    <span class="ytg-text">
                        Schedule Posts under This Category:
                    </span>
                    <span class="ytg-help-link-container">
                        (<a href="#" class="ytg-help-link" data-identifier="postCategories">help</a>)
                    </span>
                </h3>

                <?php
                $attribute = 'postCategories';
                ?>
                <div class="ytg-form-group ytg-field-<?php echo $attribute; ?>">
                    <?php echo $this->render('admin/index/post-categories', array(
                        'value' => $model->$attribute,
                    )); ?>

                    <div class="ytg-category-adder">
                        <a class="ytg-button-category-adder-toggle" href="#" class="hide-if-no-js">
                            + Add New Category
                        </a>

                        <div class="ytg-category-adder-group"
                             style="display: none"
                        >
                            <input type="text"
                                   class="ytg-input-name ytg-form-control"
                                   value=""
                            />
                            <div class="ytg-parent-category-dropdown">
                                <?php echo $this->render('admin/index/parent-category-dropdown'); ?>
                            </div>
                            <button type="button"
                                class="button ytg-category-adder-submit"
                            >
                                Add New Category
                            </button>
                            <div class="ytg-ajax-indicator"
                                 title="Adding new category..."
                                 alt="Loading..."
                            ></div>
                        </div>
                    </div>
                </div>

                <?php
                $attribute = 'postType';
                $value = $model->$attribute;
                $postTypes = ytg_Core::$app->postTypes->getContentTypes();
                ?>

                <?php if (count($postTypes) > 1): ?>
                    <h3>
                        <span class="ytg-text">
                            <?php echo $this->escape($model->getAttributeLabel($attribute)); ?>:
                        </span>
                        <span class="ytg-help-link-container">
                            (<a href="#" class="ytg-help-link" data-identifier="<?php echo $attribute; ?>">help</a>)
                        </span>
                    </h3>

                    <div class="ytg-form-group ytg-field-<?php echo $attribute; ?>">
                        <?php foreach ($model->getAttributeList($attribute) as $key=>$label): ?>
                            <?php
                            $optionId = "{$formName}-{$attribute}-{$key}";
                            ?>
                            <label for="<?php echo $optionId; ?>"
                                   class="ytg-control-label-radio ytg-option-<?php echo $key; ?>"
                            >
                                <input type="radio"
                                       name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                                       id="<?php echo $optionId; ?>"
                                       class="ytg-form-control-option"
                                       value="<?php echo $this->escape($key); ?>"
                                       <?php if ($value == $key): ?>checked="checked"<?php endif; ?>
                                >
                                <span class="ytg-text">
                                    <?php echo $this->escape($label); ?>
                                </span>
                            </label>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <?php
                    reset($postTypes);
                    $value = current($postTypes);
                    ?>
                    <input type="hidden"
                           name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                           id="<?php echo $formName; ?>-<?php echo $attribute; ?>"
                           value="<?php echo $this->escape($value); ?>"
                    >
                <?php endif; ?>
            </div>

            <!-- 3rd column -->
            <div class="ytg-form-column ytg-form-column-3">
                <h3>Select Post Template:
                    <span class="ytg-help-link-container">
                        (<a href="#" class="ytg-help-link" data-identifier="postTemplate">help</a>)
                    </span>
                </h3>

                <?php
                $attribute = 'postTemplate';
                $id = "{$formName}-{$attribute}";
                $value = $model->$attribute;
                ?>
                <div class="ytg-form-group ytg-field-<?php echo $attribute; ?><?php if ($model->isAttributeRequired($attribute)): ?> ytg-required<?php endif; ?>">
                    <select name="<?php echo $formName; ?>[<?php echo $attribute; ?>]"
                            id="<?php echo $id; ?>"
                            class="regular-text ytg-input-template"
                    >
                        <option value="">(default)</option>
                        <?php foreach ($model->getAttributeList($attribute) as $key=>$label): ?>
                            <option value="<?php echo $this->escape($key); ?>"
                                    <?php if ($key == $value): ?>selected="selected"<?php endif; ?>
                            >
                                <?php echo $this->escape($label); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <?php echo $this->render('template/_preview-widget', array(
                        'id' => $model->postTemplate,
                    )); ?>
                </div>

                <hr>

                <div class="ytg-form-buttons">
                    <div class="ytg-button-preview-container ytg-button-row">
                        <button type="submit"
                                class="ytg-button-preview button button-default"
                                name="action"
                                value="preview"
                                <?php if (isset($errors['youtube-credentials'])): ?>disabled="disabled"<?php endif; ?>
                        >
                            Preview Videos
                        </button>
                        <span class="ytg-help-link-container">
                            (<a href="#" class="ytg-help-link" data-identifier="preview">help</a>)
                        </span>
                    </div>
                    <div class="ytg-button-generate-container ytg-button-row">
                        <button type="submit"
                                class="ytg-button-generate button button-primary"
                                <?php if (isset($errors['youtube-credentials'])): ?>disabled="disabled"<?php endif; ?>
                        >
                            Generate Video Posts
                        </button>
                    </div>
                </div>
            </div>
        </div><!-- .ytg-form-columns -->

        <?php if ($preview): ?>
            <?php echo $this->render('admin/index/preview', compact('model', 'preview')); ?>
        <?php endif; ?>
    </form>
</div><!-- .ytg-form -->

<?php
$helpPath = dirname(__FILE__) . "/{$this->context->actionName}/help/";

$tips = array(
    'add-selected' => 'Add Selected',
    'preview' => 'Preview',
);

foreach ($model->safeAttributes() as $attribute) {
    if ($model->getAttributeProperty($attribute, 'help')) {
        $tips[$attribute] = $model->getAttributeLabel($attribute);
    }
}

foreach ($model->getSearchModeList() as $key=>$label) {
    $tips["searchMode-{$key}"] = $label;
}
foreach ($model->getPublicationMethodList() as $key=>$label) {
    $tips["publicationMethod-{$key}"] = $label;
}

foreach ($tips as $id=>$label) {
    echo $this->render('_help/popup', array(
        'identifier' => $id,
        'title' => $label,
        'path' => $helpPath . $id . '.php',
    ));
}