<?php
if (!isset($urlBase)) {
    $urlBase = 'admin.php?';
}
?>
<div class="tablenav-pages ytg-pagination">
    <?php if ($grid->totalCount): ?>
        <span class="displaying-num">
            <?php if ($grid->filter): ?>
                Found
                <?php echo $grid->count; ?>
                of
            <?php endif; ?>

            <?php echo $grid->totalCount; ?>
            <?php if (1 != $grid->totalCount): ?>
                items
            <?php else: ?>
                item
            <?php endif; ?>

        </span>
    <?php endif; ?>
    <?php if ($grid->pageCount > 1): ?>
        <span class="pagination-links">
            <?php if ($grid->page > 2): ?>
                <a class="first-page" href="<?php echo $this->escape(admin_url($urlBase . $grid->createQuery(array('page' => 1)))); ?>">
                    <span class="screen-reader-text">First page</span>
                    <span aria-hidden="true">«</span>
                </a>
            <?php else: ?>
                <span class="tablenav-pages-navspan" aria-hidden="true">«</span>
            <?php endif; ?>

            <?php if ($grid->page > 1): ?>
                <a class="prev-page" href="<?php echo $this->escape(admin_url($urlBase . $grid->createQuery(array('page' => $grid->page - 1)))); ?>">
                    <span class="screen-reader-text">Previous page</span>
                    <span aria-hidden="true">‹</span>
                </a>
            <?php else: ?>
                <span class="tablenav-pages-navspan" aria-hidden="true">‹</span>
            <?php endif; ?>

            <span class="paging-input">
                <label class="screen-reader-text">Current Page</label>
                <input class="current-page"
                    type="text"
                    data-url-template="<?php echo $this->escape(admin_url($urlBase . $grid->createQuery(array('page' => '{value}')))); ?>"
                    value="<?php echo $grid->page; ?>"
                    size="1"
                    aria-describedby="table-paging"
                >
                of
                <span class="total-pages"><?php echo $grid->pageCount; ?></span>
            </span>

            <?php if ($grid->page < $grid->pageCount): ?>
                <a class="next-page" href="<?php echo $this->escape(admin_url($urlBase . $grid->createQuery(array('page' => $grid->page + 1)))); ?>">
                    <span class="screen-reader-text">Next page</span>
                    <span aria-hidden="true">›</span>
                </a>
            <?php else: ?>
                <span class="tablenav-pages-navspan" aria-hidden="true">›</span>
            <?php endif; ?>

            <?php if ($grid->page < $grid->pageCount-1): ?>
                <a class="last-page" href="<?php echo $this->escape(admin_url($urlBase . $grid->createQuery(array('page' => $grid->pageCount)))); ?>">
                    <span class="screen-reader-text">Last page</span>
                    <span aria-hidden="true">»</span>
                </a>
            <?php else: ?>
                <span class="tablenav-pages-navspan" aria-hidden="true">»</span>
            <?php endif; ?>
        </span>
    <?php endif; ?>
</div>