<?php
if (!isset($urlBase)) {
    $urlBase = 'admin.php?';
}
?>
<table class="<?php echo $grid->tableClass; ?>">
    <?php require dirname(__FILE__) . '/_header.php'; ?>
    <tbody>
        <?php if ($grid->count): ?>
            <?php foreach ($grid->getRows() as $model): ?>
                <tr>
                    <?php foreach ($grid->columns as $name=>$column): ?>
                        <td class="<?php echo $column['class']; ?>">
                        <?php
                            $value = $grid->cellValue($model, $name);
                            $formattedValue = $this->format($value, $column['format']);
                            if ('' != $grid->templateDirectory) {
                                $template = "{$grid->templateDirectory}/values/{$name}";
                                if ($this->viewFileExists($template)) {
                                    $formattedValue = $this->render($template, compact('grid', 'model', 'name', 'column', 'value', 'formattedValue'));
                                }
                            }

                            echo $formattedValue;
                        ?>
                        </td>
                    <?php endforeach; ?>
                </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <?php require dirname(__FILE__) . '/_not-found.php'; ?>
        <?php endif; ?>
    </tbody>
    <?php require dirname(__FILE__) . '/_footer.php'; ?>
</table>