<?php foreach ($grid->columns as $name=>$column): ?>
    <?php
        $template = "{$grid->templateDirectory}/headers/{$name}";
        if ($this->viewFileExists($template)) {
            $label = $this->render($template, compact('grid', 'name', 'column'));
        } else {
            $label = isset($column['label'])
                ? $this->format($column['label'], $column['labelFormat'])
                : '';
        }
    ?>
    <?php if (isset($column['sortDirection'])): ?>
        <th scope="col" class="manage-column sorted <?php echo strtolower($column['sortDirection']); ?> <?php echo $column['class']; ?>">
            <a href="<?php echo $this->escape(admin_url($urlBase . $grid->createQuery(array('sort' => array($name, 'ASC' == $column['sortDirection']? 'DESC' : 'ASC'), 'page'=>1)))); ?>">
                <?php if ('' != $label): ?>
                    <span><?php echo $label; ?></span>
                <?php endif; ?>
                <span class="sorting-indicator"></span>
            </a>
        </th>
    <?php elseif ($column['sortable']): ?>
        <?php $sortDirection = isset($column['defaultSortDirection'])? $column['defaultSortDirection'] : 'ASC'; ?>
        <th scope="col" class="manage-column sortable <?php echo 'ASC' == $sortDirection? 'desc' : 'asc'; ?> <?php echo $column['class']; ?>">
            <a href="<?php echo $this->escape(admin_url($urlBase . $grid->createQuery(array('sort' => array($name, $sortDirection), 'page'=>1)))); ?>">
                <?php if ('' != $label): ?>
                    <span><?php echo $label; ?></span>
                <?php endif; ?>
                <span class="sorting-indicator"></span>
            </a>
        </th>
    <?php else: ?>
        <th scope="col" class="manage-column <?php echo $column['class']; ?>">
            <?php if ('' != $label): ?>
                <?php echo $label; ?>
            <?php endif; ?>
        </th>
    <?php endif; ?>
<?php endforeach; ?>